/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import javax.servlet.ServletContext;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.TideServiceContext;
import org.granite.tide.TideServiceInvoker;
import org.granite.tide.data.PersistenceExceptionConverter;
import org.granite.tide.spring.SpringServiceContext;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceFactory
extends ServiceFactory {
    private static final Logger log = Logger.getLogger(SpringServiceFactory.class);
    public static final String PERSISTENCE_MANAGER_BEAN_NAME = "persistence-manager-bean-name";
    public static final String ENTITY_MANAGER_FACTORY_BEAN_NAME = "entity-manager-factory-bean-name";
    private ApplicationContext springContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.springContext = applicationContext;
    }

    public void configure(XMap properties) throws ServiceException {
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        if (sServiceExceptionHandler == null) {
            XMap props = new XMap(properties);
            props.put("service-exception-handler", ExtendedServiceExceptionHandler.class.getName());
            super.configure(props);
        } else {
            super.configure(properties);
        }
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        try {
            graniteContext.getGraniteConfig().registerExceptionConverter(PersistenceExceptionConverter.class);
        }
        catch (Throwable t) {
            log.info(t, "JPA exception converter not registered (JPA not found on classpath)", new Object[0]);
        }
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        Destination destination;
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map cache = context.getSessionMap(false);
        if (cache == null) {
            cache = context.getRequestMap();
        }
        if ((destination = context.getServicesConfig().findDestinationById(messageType, destinationId)) == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String key = String.valueOf(TideServiceInvoker.class.getName()) + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context.getSessionMap(false) == null) {
            return this.internalGetServiceInvoker(cache, destination, key);
        }
        Object object = context.getSessionLock();
        synchronized (object) {
            return this.internalGetServiceInvoker(cache, destination, key);
        }
    }

    private ServiceInvoker<?> internalGetServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        ServiceInvoker invoker = (ServiceInvoker)cache.get(key);
        if (invoker == null) {
            SpringServiceContext tideContext = null;
            ServletContext sc = ((HttpGraniteContext)GraniteContext.getCurrentInstance()).getServletContext();
            Object springContext = this.springContext != null ? this.springContext : WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
            Map beans = springContext.getBeansOfType(SpringServiceContext.class);
            if (beans.size() > 1) {
                throw new RuntimeException("More than one SpringServiceContext bean found");
            }
            if (beans.size() == 1) {
                tideContext = (SpringServiceContext)((Object)beans.values().iterator().next());
            } else {
                String className = "org.granite.tide.spring.SpringMVCServiceContext";
                try {
                    Class clazz = TypeUtil.forName((String)className, SpringServiceContext.class);
                    tideContext = (SpringServiceContext)((Object)clazz.getConstructor(ApplicationContext.class).newInstance(springContext));
                }
                catch (Exception e) {
                    tideContext = new SpringServiceContext((ApplicationContext)springContext);
                }
            }
            String persistenceManagerBeanName = destination.getProperties().get(PERSISTENCE_MANAGER_BEAN_NAME);
            tideContext.setPersistenceManagerBeanName(persistenceManagerBeanName);
            String entityManagerFactoryBeanName = destination.getProperties().get(ENTITY_MANAGER_FACTORY_BEAN_NAME);
            tideContext.setEntityManagerFactoryBeanName(entityManagerFactoryBeanName);
            invoker = new TideServiceInvoker(destination, (ServiceFactory)this, (TideServiceContext)tideContext);
            cache.put(key, invoker);
        }
        return invoker;
    }
}

