/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring.data;

import java.util.ArrayList;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.granite.tide.spring.data.FilterSpecUtil;
import org.springframework.data.jpa.domain.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMapSpecification<T>
implements Specification<T> {
    private Map<String, Object> filter;

    private FilterMapSpecification(Map<String, Object> filter) {
        this.filter = filter;
    }

    public static <T> FilterMapSpecification<T> byMap(Map<String, Object> filter) {
        return new FilterMapSpecification<T>(filter);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Map.Entry<String, Object> entry : this.filter.entrySet()) {
            if (root.get(entry.getKey()) == null) {
                throw new RuntimeException("Invalid filter mapping, path: " + entry.getKey());
            }
            Predicate predicate = FilterSpecUtil.buildPredicate(root, builder, null, entry.getKey(), entry.getValue());
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        if (predicates.size() > 0) {
            return builder.and(predicates.toArray(new Predicate[predicates.size()]));
        }
        return null;
    }
}

