/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AbstractAuthenticationManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcegiSecurityService
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(AcegiSecurityService.class);
    private static final String SPRING_AUTHENTICATION_TOKEN = AcegiSecurityService.class.getName() + ".SPRING_AUTHENTICATION_TOKEN";

    public AcegiSecurityService() {
        log.debug("Starting Service!", new Object[0]);
    }

    public void configure(Map<String, String> params) {
        log.debug("Configuring with parameters (NOOP) %s: ", new Object[]{params});
    }

    public void login(Object credentials, String charset) {
        List<String> decodedCredentials = Arrays.asList(this.decodeBase64Credentials(credentials, charset));
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        String user = decodedCredentials.get(0);
        String password = decodedCredentials.get(1);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)httpRequest.getSession().getServletContext());
        if (ctx != null) {
            AbstractAuthenticationManager authenticationManager = (AbstractAuthenticationManager)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)ctx, AbstractAuthenticationManager.class);
            try {
                Authentication authentication = authenticationManager.authenticate((Authentication)auth);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                httpRequest.getSession().setAttribute(SPRING_AUTHENTICATION_TOKEN, (Object)authentication);
                this.endLogin(credentials, charset);
            }
            catch (AuthenticationException e) {
                this.handleAuthenticationExceptions(e);
            }
        }
        log.debug("User %s logged in", new Object[]{user});
    }

    protected void handleAuthenticationExceptions(AuthenticationException e) {
        if (e instanceof BadCredentialsException || e instanceof UsernameNotFoundException) {
            throw SecurityServiceException.newInvalidCredentialsException((String)e.getMessage());
        }
        throw SecurityServiceException.newAuthenticationFailedException((String)e.getMessage());
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        Object securityContext;
        log.debug("Authorize: %s", new Object[]{context});
        log.debug("Is %s secured? %b", new Object[]{context.getDestination().getId(), context.getDestination().isSecured()});
        this.startAuthorization(context);
        Authentication authentication = this.getAuthentication();
        if (context.getDestination().isSecured()) {
            if (!this.isAuthenticated(authentication)) {
                log.debug("Is not authenticated!", new Object[0]);
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (!this.userCanAccessService(context, authentication)) {
                log.debug("Access denied for: %s", new Object[]{authentication.getName()});
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        if (this.isAuthenticated(authentication)) {
            securityContext = SecurityContextHolder.getContext();
            securityContext.setAuthentication(authentication);
        }
        try {
            securityContext = this.endAuthorization(context);
            return securityContext;
        }
        catch (InvocationTargetException e) {
            this.handleAuthorizationExceptions(e);
            throw e;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        context.getSession().invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
    }

    protected boolean isUserInRole(Authentication authentication, String role) {
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!ga.getAuthority().matches(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthenticated(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean userCanAccessService(AbstractSecurityContext context, Authentication authentication) {
        log.debug("Is authenticated as: %s", new Object[]{authentication.getName()});
        for (String role : context.getDestination().getRoles()) {
            if (this.isUserInRole(authentication, role)) {
                log.debug("Allowed access to %s in role %s", new Object[]{authentication.getName(), role});
                return true;
            }
            log.debug("Access denied for %s not in role %s", new Object[]{authentication.getName(), role});
        }
        return false;
    }

    protected Authentication getAuthentication() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        Authentication authentication = (Authentication)httpRequest.getSession().getAttribute(SPRING_AUTHENTICATION_TOKEN);
        return authentication;
    }

    protected void handleAuthorizationExceptions(InvocationTargetException e) {
        for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
            if (!(t instanceof SecurityException) && !(t instanceof AccessDeniedException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
            throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
        }
    }
}

