/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.security.DestinationSecurizer;
import org.granite.messaging.service.security.RemotingDestinationSecurizer;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.messaging.webapp.AMFEndpoint;
import org.granite.spring.SpringGraniteConfig;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFilter
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ServletContextAware,
HandlerAdapter {
    private static final Logger log = Logger.getLogger(ServerFilter.class);
    @Autowired(required=false)
    private ServletContext servletContext = null;
    private ApplicationContext context = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    private List<String> tideRoles = null;
    private List<String> tideAnnotations = null;
    private List<String> tideInterfaces = null;
    private List<String> tideNames = null;
    private List<String> tideTypes = null;
    private List<Class<? extends ExceptionConverter>> exceptionConverters = null;
    private AMF3MessageInterceptor amf3MessageInterceptor;
    private boolean tide = false;
    private String type = "server";
    private AMFEndpoint amfEndpoint = null;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setServletContext(ServletContext servletContext) throws BeansException {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() {
        Service service;
        SpringGraniteConfig springGraniteConfig = (SpringGraniteConfig)((Object)this.context.getBeansOfType(SpringGraniteConfig.class).values().iterator().next());
        this.graniteConfig = springGraniteConfig.getGraniteConfig();
        Map securityServices = this.context.getBeansOfType(SecurityService.class);
        if (securityServices.size() > 1) {
            log.error("More than one Security Service bean defined", new Object[0]);
        } else if (!securityServices.isEmpty()) {
            log.debug("Security Service bean " + (String)securityServices.keySet().iterator().next() + " selected", new Object[0]);
            SecurityService securityService = (SecurityService)securityServices.values().iterator().next();
            this.graniteConfig.setSecurityService(securityService);
        }
        if (this.tideAnnotations != null) {
            for (String string : this.tideAnnotations) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(string, false));
                    log.debug("Enabled components annotated with %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component annotation %s", new Object[]{string});
                }
            }
        }
        if (this.tideInterfaces != null) {
            for (String string : this.tideInterfaces) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(string, false));
                    log.debug("Enabled components extending %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component interface %s", new Object[]{string});
                }
            }
        }
        if (this.tideNames != null) {
            for (String string : this.tideNames) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(string, false));
                    log.debug("Enabled components named like %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component name %s", new Object[]{string});
                }
            }
        }
        if (this.tideTypes != null) {
            for (String string : this.tideTypes) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(string, false));
                    log.debug("Enabled components with type %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component type %s", new Object[]{string});
                }
            }
        }
        if (this.exceptionConverters != null) {
            for (Class clazz : this.exceptionConverters) {
                this.graniteConfig.registerExceptionConverter(clazz);
                log.debug("Registered exception converter %s", new Object[]{clazz});
            }
        }
        if (this.amf3MessageInterceptor != null) {
            this.graniteConfig.setAmf3MessageInterceptor(this.amf3MessageInterceptor);
        }
        try {
            TypeUtil.forName((String)"org.springframework.data.domain.Page");
            Class converterClass = TypeUtil.forName((String)"org.granite.spring.data.PageableConverter", Converter.class);
            this.graniteConfig.getConverters().addConverter(converterClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.servicesConfig = springGraniteConfig.getServicesConfig();
        Channel channel = this.servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            this.servicesConfig.addChannel(channel);
        }
        if (this.tide) {
            Destination destination;
            Factory factory = this.servicesConfig.findFactoryById("tide-spring-factory");
            if (factory == null) {
                Factory factory2 = new Factory("tide-spring-factory", "org.granite.tide.spring.SpringServiceFactory", new XMap());
                this.servicesConfig.addFactory(factory2);
            }
            if ((service = this.servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            }
            if ((destination = this.servicesConfig.findDestinationById("flex.messaging.messages.RemotingMessage", this.type)) == null) {
                void var4_16;
                ArrayList<String> channelIds = new ArrayList<String>();
                channelIds.add("graniteamf");
                destination = new Destination(this.type, channelIds, new XMap(), this.tideRoles, null, null);
                destination.getProperties().put("factory", var4_16.getId());
                destination.getProperties().put("validator-name", "tideValidator");
                service.getDestinations().put(destination.getId(), destination);
                this.servicesConfig.addService(service);
            }
            if (destination.getSecurizer() == null) {
                Map securizers = this.context.getBeansOfType(RemotingDestinationSecurizer.class);
                if (securizers.size() > 1) {
                    log.error("More than one Remoting Destination Securizer bean defined", new Object[0]);
                } else if (!securizers.isEmpty()) {
                    log.debug("Remoting Destination Securizer bean " + (String)securizers.keySet().iterator().next() + " selected", new Object[0]);
                    RemotingDestinationSecurizer securizer = (RemotingDestinationSecurizer)securizers.values().iterator().next();
                    destination.setSecurizer((DestinationSecurizer)securizer);
                }
            }
            log.info("Registered Tide/Spring service factory and destination %s", new Object[]{this.type});
        } else {
            Factory factory = this.servicesConfig.findFactoryById("spring-factory");
            if (factory == null) {
                Factory factory3 = new Factory("spring-factory", "org.granite.spring.SpringServiceFactory", new XMap());
                this.servicesConfig.addFactory(factory3);
            }
            if ((service = this.servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
                this.servicesConfig.addService(service);
            }
            this.servicesConfig.scan(null);
            log.info("Registered Spring service factory", new Object[0]);
        }
        this.amfEndpoint = new AMFEndpoint();
        this.amfEndpoint.init(this.servletContext);
    }

    public void destroy() throws Exception {
        this.amfEndpoint.destroy();
        this.amfEndpoint = null;
    }

    public void setTideRoles(List<String> tideRoles) {
        this.tideRoles = tideRoles;
    }

    public void setTideAnnotations(List<String> tideAnnotations) {
        this.tideAnnotations = tideAnnotations;
    }

    public void setTideInterfaces(List<String> tideInterfaces) {
        this.tideInterfaces = tideInterfaces;
    }

    public void setTideNames(List<String> tideNames) {
        this.tideNames = tideNames;
    }

    public void setTideTypes(List<String> tideTypes) {
        this.tideTypes = tideTypes;
    }

    public void setExceptionConverters(List<Class<? extends ExceptionConverter>> exceptionConverters) {
        this.exceptionConverters = exceptionConverters;
    }

    public void setAmf3MessageInterceptor(AMF3MessageInterceptor amf3MessageInterceptor) {
        this.amf3MessageInterceptor = amf3MessageInterceptor;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.amfEndpoint.service(this.graniteConfig, this.servicesConfig, this.servletContext, request, response);
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof ServerFilter;
    }
}

