/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring.data;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.granite.messaging.jmf.ExtendedObjectInput;
import org.granite.messaging.jmf.ExtendedObjectOutput;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.tide.data.model.PageInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableCodec
implements ExtendedObjectCodec {
    private static final Field pageableField;

    public boolean canEncode(ExtendedObjectOutput out, Object v) {
        return v instanceof Page;
    }

    public String getEncodedClassName(ExtendedObjectOutput out, Object v) {
        return org.granite.tide.data.model.Page.class.getName();
    }

    public void encode(ExtendedObjectOutput out, Object v) throws IOException, IllegalAccessException, InvocationTargetException {
        int offset;
        Page springPage = (Page)v;
        if (pageableField == null) {
            offset = springPage.getNumber() * springPage.getSize();
        } else {
            Pageable springPageable = (Pageable)pageableField.get(springPage);
            offset = springPageable.getOffset();
        }
        out.writeObject((Object)offset);
        out.writeObject((Object)springPage.getSize());
        out.writeObject((Object)((int)springPage.getTotalElements()));
        out.writeObject(new ArrayList(springPage.getContent()));
    }

    public boolean canDecode(ExtendedObjectInput in, String className) throws ClassNotFoundException {
        return PageInfo.class.getName().equals(className);
    }

    public String getDecodedClassName(ExtendedObjectInput in, String className) {
        return PageRequest.class.getName();
    }

    public Object newInstance(ExtendedObjectInput in, String className) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        int firstResult = (Integer)in.readObject();
        int maxResults = (Integer)in.readObject();
        String[] orderBys = (String[])in.readObject();
        boolean[] orderDescs = (boolean[])in.readObject();
        Sort sort = null;
        if (this.checkSort(orderBys, orderDescs)) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(orderBys.length);
            for (int i = 0; i < orderBys.length; ++i) {
                orders.add(new Sort.Order(orderDescs[i] ? Sort.Direction.DESC : Sort.Direction.ASC, orderBys[i]));
            }
            sort = new Sort(orders);
        }
        return new PageRequest(maxResults > 0 ? firstResult / maxResults : 0, maxResults, sort);
    }

    public void decode(ExtendedObjectInput in, Object v) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
    }

    private boolean checkSort(String[] orderBys, boolean[] orderDescs) {
        if (orderBys != null) {
            if (orderDescs == null) {
                throw new IllegalArgumentException("orderBys == " + Arrays.toString(orderBys) + " but sortDescs == null");
            }
            if (orderDescs.length != orderBys.length) {
                throw new IllegalArgumentException("orderBys == " + Arrays.toString(orderBys) + " but sortDescs == " + Arrays.toString(orderBys));
            }
            return orderBys.length > 0;
        }
        if (orderDescs != null) {
            throw new IllegalArgumentException("orderBys == null but sortDescs != null");
        }
        return false;
    }

    static {
        Field pageableFieldTmp = null;
        try {
            pageableFieldTmp = Page.class.getDeclaredField("pageable");
            pageableFieldTmp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        pageableField = pageableFieldTmp;
    }
}

