/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.spring.security.AbstractSpringSecurity3Interceptor;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurity3Service
extends AbstractSecurityService
implements ApplicationContextAware,
ApplicationEventPublisherAware {
    private static final Logger log = Logger.getLogger(SpringSecurity3Service.class);
    private static final String FILTER_APPLIED = "__spring_security_scpf_applied";
    private static final String SECURITY_SERVICE_APPLIED = "__spring_security_granite_service_applied";
    private ApplicationContext applicationContext = null;
    private ApplicationEventPublisher eventPublisher = null;
    private AuthenticationManager authenticationManager = null;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
    private AbstractSpringSecurity3Interceptor securityInterceptor = null;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy = new SessionFixationProtectionStrategy();
    private PasswordEncoder passwordEncoder = null;
    private String authenticationManagerBeanName = null;
    private boolean allowAnonymousAccess = false;
    private Method getRequest = null;
    private Method getResponse = null;

    public SpringSecurity3Service() {
        log.debug("Starting Spring 3 Security Service", new Object[0]);
        try {
            this.getRequest = HttpRequestResponseHolder.class.getDeclaredMethod("getRequest", new Class[0]);
            this.getRequest.setAccessible(true);
            this.getResponse = HttpRequestResponseHolder.class.getDeclaredMethod("getResponse", new Class[0]);
            this.getResponse.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get methods from HttpRequestResponseHolder", e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }

    public void setSecurityInterceptor(AbstractSpringSecurity3Interceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        if (sessionAuthenticationStrategy == null) {
            throw new NullPointerException("SessionAuthenticationStrategy cannot be null");
        }
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(Map<String, String> params) {
        log.debug("Configuring with parameters %s: ", new Object[]{params});
        if (params.containsKey("authentication-manager-bean-name")) {
            this.authenticationManagerBeanName = params.get("authentication-manager-bean-name");
        }
        if (Boolean.TRUE.toString().equals(params.get("allow-anonymous-access"))) {
            this.allowAnonymousAccess = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Object credentials, String charset) {
        ApplicationContext appContext;
        List<String> decodedCredentials = Arrays.asList(this.decodeBase64Credentials(credentials, charset));
        if (!(GraniteContext.getCurrentInstance() instanceof HttpGraniteContext)) {
            log.info("Login from non HTTP granite context ignored", new Object[0]);
            return;
        }
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        String user = decodedCredentials.get(0);
        String password = decodedCredentials.get(1);
        if (this.passwordEncoder != null) {
            password = this.passwordEncoder.encodePassword(password, null);
        }
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        Object object = appContext = this.applicationContext != null ? this.applicationContext : WebApplicationContextUtils.getWebApplicationContext((ServletContext)graniteContext.getServletContext());
        if (appContext != null) {
            this.lookupAuthenticationManager(appContext, this.authenticationManagerBeanName);
            try {
                Authentication authentication = this.authenticationManager.authenticate((Authentication)auth);
                if (authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication)) {
                    try {
                        this.sessionAuthenticationStrategy.onAuthentication(authentication, httpRequest, graniteContext.getResponse());
                    }
                    catch (SessionAuthenticationException e) {
                        log.debug((Throwable)e, "SessionAuthenticationStrategy rejected the authentication object", new Object[0]);
                        SecurityContextHolder.clearContext();
                        this.handleAuthenticationExceptions((AuthenticationException)((Object)e));
                        log.debug("Clear authentication", new Object[0]);
                        SecurityContextHolder.clearContext();
                        return;
                    }
                }
                log.debug("Define authentication and save to repo: %s", new Object[]{authentication != null ? authentication.getName() : "none"});
                HttpRequestResponseHolder holder = new HttpRequestResponseHolder(graniteContext.getRequest(), graniteContext.getResponse());
                SecurityContext securityContext = this.securityContextRepository.loadContext(holder);
                securityContext.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)securityContext);
                try {
                    this.securityContextRepository.saveContext(securityContext, (HttpServletRequest)this.getRequest.invoke((Object)holder, new Object[0]), (HttpServletResponse)this.getResponse.invoke((Object)holder, new Object[0]));
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not save context after authentication", new Object[0]);
                }
                if (this.eventPublisher != null) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authentication));
                }
                this.endLogin(credentials, charset);
            }
            catch (AuthenticationException e) {
                this.handleAuthenticationExceptions(e);
            }
            finally {
                log.debug("Clear authentication", new Object[0]);
                SecurityContextHolder.clearContext();
            }
        }
        log.debug("User %s logged in", new Object[]{user});
    }

    protected void handleAuthenticationExceptions(AuthenticationException e) {
        if (e instanceof BadCredentialsException || e instanceof UsernameNotFoundException) {
            throw SecurityServiceException.newInvalidCredentialsException((String)e.getMessage());
        }
        throw SecurityServiceException.newAuthenticationFailedException((String)e.getMessage());
    }

    public void lookupAuthenticationManager(ApplicationContext ctx, String authenticationManagerBeanName) throws SecurityServiceException {
        if (this.authenticationManager != null) {
            return;
        }
        Map authManagers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, AuthenticationManager.class);
        if (authenticationManagerBeanName != null) {
            this.authenticationManager = (AuthenticationManager)authManagers.get(authenticationManagerBeanName);
            if (this.authenticationManager == null) {
                log.error("AuthenticationManager bean not found " + authenticationManagerBeanName, new Object[0]);
                throw SecurityServiceException.newAuthenticationFailedException((String)"Authentication failed");
            }
            return;
        }
        if (authManagers.size() > 1) {
            log.error("More than one AuthenticationManager beans found, specify which one to use in Spring config <graniteds:security-service authentication-manager='myAuthManager'/> or in granite-config.xml <security type='org.granite.spring.security.SpringSecurity3Service'><param name='authentication-manager-bean-name' value='myAuthManager'/></security>", new Object[0]);
            throw SecurityServiceException.newAuthenticationFailedException((String)"Authentication failed");
        }
        this.authenticationManager = (AuthenticationManager)authManagers.values().iterator().next();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object authorize(AbstractSecurityContext context) throws Exception {
        block23: {
            block24: {
                SpringSecurity3Service.log.debug("Authorize %s on destination %s (secured: %b)", new Object[]{context, context.getDestination().getId(), context.getDestination().isSecured()});
                this.startAuthorization(context);
                graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
                authentication = SecurityContextHolder.getContext().getAuthentication();
                holder = null;
                if (graniteContext.getRequest().getAttribute("__spring_security_scpf_applied") == null) {
                    if (graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") == null) {
                        holder = new HttpRequestResponseHolder(graniteContext.getRequest(), graniteContext.getResponse());
                        contextBeforeChainExecution = this.securityContextRepository.loadContext(holder);
                        SecurityContextHolder.setContext((SecurityContext)contextBeforeChainExecution);
                        if (this.isAuthenticated(authentication)) {
                            SpringSecurity3Service.log.debug("Restore authentication: %s", new Object[]{authentication.getName()});
                            contextBeforeChainExecution.setAuthentication(authentication);
                        } else {
                            authentication = contextBeforeChainExecution.getAuthentication();
                            SpringSecurity3Service.log.debug("Restore authentication from repository: %s", new Object[]{authentication != null ? authentication.getName() : "none"});
                        }
                        graniteContext.getRequest().setAttribute("__spring_security_granite_service_applied", (Object)0);
                    } else {
                        SpringSecurity3Service.log.debug("Increment service reentrance counter", new Object[0]);
                        graniteContext.getRequest().setAttribute("__spring_security_granite_service_applied", (Object)((Integer)graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") + 1));
                    }
                }
                try {
                    try {
                        if (context.getDestination().isSecured()) {
                            if (!this.isAuthenticated(authentication) || !this.allowAnonymousAccess && authentication instanceof AnonymousAuthenticationToken) {
                                SpringSecurity3Service.log.debug("User not authenticated!", new Object[0]);
                                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
                            }
                            if (!this.userCanAccessService(context, authentication)) {
                                SpringSecurity3Service.log.debug("Access denied for user %s", new Object[]{authentication != null ? authentication.getName() : "not authenticated"});
                                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
                            }
                        }
                        var6_9 = returnedObject = this.securityInterceptor != null ? this.securityInterceptor.invoke(context) : this.endAuthorization(context);
                        var8_10 = null;
                    }
                    catch (SecurityServiceException e) {
                        throw e;
                    }
                    catch (AccessDeniedException e) {
                        throw SecurityServiceException.newAccessDeniedException((String)e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        this.handleAuthorizationExceptions(e);
                        throw e;
                    }
                }
                catch (Throwable var7_16) {
                    var8_11 = null;
                    if (graniteContext.getRequest().getAttribute("__spring_security_scpf_applied") != null) throw var7_16;
                    if ((Integer)graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") == 0) {
                        contextAfterChainExecution = SecurityContextHolder.getContext();
                        SpringSecurity3Service.log.debug("Clear authentication and save to repo: %s", new Object[]{contextAfterChainExecution.getAuthentication() != null ? contextAfterChainExecution.getAuthentication().getName() : "none"});
                        SecurityContextHolder.clearContext();
                        try {
                            this.securityContextRepository.saveContext(contextAfterChainExecution, (HttpServletRequest)this.getRequest.invoke((Object)holder, new Object[0]), (HttpServletResponse)this.getResponse.invoke((Object)holder, new Object[0]));
                        }
                        catch (Exception e) {
                            SpringSecurity3Service.log.error((Throwable)e, "Could not extract wrapped context from holder", new Object[0]);
                        }
                        graniteContext.getRequest().removeAttribute("__spring_security_granite_service_applied");
                        throw var7_16;
                    }
                    if (graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") == null) {
                        SpringSecurity3Service.log.debug("Clear authentication", new Object[0]);
                        SecurityContextHolder.clearContext();
                        throw var7_16;
                    }
                    SpringSecurity3Service.log.debug("Decrement service reentrance counter", new Object[0]);
                    graniteContext.getRequest().setAttribute("__spring_security_granite_service_applied", (Object)((Integer)graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") - 1));
                    throw var7_16;
                }
                if (graniteContext.getRequest().getAttribute("__spring_security_scpf_applied") != null) return var6_9;
                if ((Integer)graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") != 0) break block23;
                contextAfterChainExecution = SecurityContextHolder.getContext();
                SpringSecurity3Service.log.debug("Clear authentication and save to repo: %s", new Object[]{contextAfterChainExecution.getAuthentication() != null ? contextAfterChainExecution.getAuthentication().getName() : "none"});
                SecurityContextHolder.clearContext();
                ** try [egrp 2[TRYBLOCK] [5 : 518->564)] { 
lbl71:
                // 1 sources

                this.securityContextRepository.saveContext(contextAfterChainExecution, (HttpServletRequest)this.getRequest.invoke((Object)holder, new Object[0]), (HttpServletResponse)this.getResponse.invoke((Object)holder, new Object[0]));
                break block24;
lbl73:
                // 1 sources

                catch (Exception e) {
                    SpringSecurity3Service.log.error((Throwable)e, "Could not extract wrapped context from holder", new Object[0]);
                }
            }
            graniteContext.getRequest().removeAttribute("__spring_security_granite_service_applied");
            return var6_9;
        }
        if (graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") == null) {
            SpringSecurity3Service.log.debug("Clear authentication", new Object[0]);
            SecurityContextHolder.clearContext();
            return var6_9;
        }
        SpringSecurity3Service.log.debug("Decrement service reentrance counter", new Object[0]);
        graniteContext.getRequest().setAttribute("__spring_security_granite_service_applied", (Object)((Integer)graniteContext.getRequest().getAttribute("__spring_security_granite_service_applied") - 1));
        return var6_9;
    }

    public boolean acceptsContext() {
        return GraniteContext.getCurrentInstance() instanceof ServletGraniteContext;
    }

    public void logout() {
        ServletGraniteContext context = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpSession session = context.getSession(false);
        if (session != null && this.securityContextRepository.containsContext(context.getRequest())) {
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
    }

    protected boolean isUserInRole(Authentication authentication, String role) {
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!ga.getAuthority().matches(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthenticated(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean userCanAccessService(AbstractSecurityContext context, Authentication authentication) {
        log.debug("Is authenticated as: %s", new Object[]{authentication.getName()});
        for (String role : context.getDestination().getRoles()) {
            if (this.isUserInRole(authentication, role)) {
                log.debug("Allowed access to %s in role %s", new Object[]{authentication.getName(), role});
                return true;
            }
            log.debug("Access denied for %s not in role %s", new Object[]{authentication.getName(), role});
        }
        return false;
    }

    protected void handleAuthorizationExceptions(InvocationTargetException e) {
        for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
            if (t instanceof SecurityException || t instanceof AccessDeniedException || "javax.ejb.EJBAccessException".equals(t.getClass().getName())) {
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            if (!(t instanceof AuthenticationException)) continue;
            throw SecurityServiceException.newNotLoggedInException((String)t.getMessage());
        }
    }
}

