/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.util.HashMap;
import java.util.Map;
import org.granite.tide.data.TideSynchronizationManager;
import org.granite.util.TypeUtil;
import org.springframework.orm.jpa.EntityManagerHolder;

public class JPASynchronizationManager
implements TideSynchronizationManager {
    private Map<String, TideSynchronizationManager> syncsMap = new HashMap<String, TideSynchronizationManager>();

    public JPASynchronizationManager() {
        try {
            this.syncsMap.put("org.hibernate.impl.SessionImpl", (TideSynchronizationManager)TypeUtil.newInstance((String)"org.granite.tide.spring.Hibernate3SynchronizationManager", TideSynchronizationManager.class));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.syncsMap.put("org.hibernate.internal.SessionImpl", (TideSynchronizationManager)TypeUtil.newInstance((String)"org.granite.tide.spring.Hibernate4SynchronizationManager", TideSynchronizationManager.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean registerSynchronization(Object resource, boolean shouldRemoveContextAtEnd) {
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)resource;
        Object delegate = entityManagerHolder.getEntityManager().getDelegate();
        if (this.syncsMap.containsKey(delegate.getClass().getName())) {
            return this.syncsMap.get(delegate.getClass().getName()).registerSynchronization(delegate, shouldRemoveContextAtEnd);
        }
        return false;
    }
}

