/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.granite.logging.Logger;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.AbstractTidePersistenceManager;
import org.granite.tide.data.JDOPersistenceManager;
import org.granite.tide.data.NoPersistenceManager;
import org.granite.tide.spring.SpringJPAPersistenceManager;
import org.granite.tide.spring.SpringTransactionManager;
import org.granite.util.TypeUtil;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.jdo.JdoTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringPersistenceManager
implements TidePersistenceManager {
    private static final Logger log = Logger.getLogger(SpringPersistenceManager.class);
    private TidePersistenceManager pm;

    public SpringPersistenceManager(PlatformTransactionManager transactionManager) {
        block9: {
            SpringTransactionManager tm = new SpringTransactionManager(transactionManager);
            if (transactionManager instanceof JpaTransactionManager) {
                this.pm = new SpringJPAPersistenceManager((JpaTransactionManager)transactionManager, tm);
                return;
            }
            if (transactionManager instanceof JdoTransactionManager) {
                this.pm = new JDOPersistenceManager(((JdoTransactionManager)transactionManager).getPersistenceManagerFactory(), (TideTransactionManager)tm);
                return;
            }
            if (transactionManager instanceof HibernateTransactionManager) {
                try {
                    Object sf = transactionManager.getClass().getMethod("getSessionFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
                    Class sfClass = TypeUtil.forName((String)"org.hibernate.SessionFactory");
                    this.pm = (TidePersistenceManager)TypeUtil.newInstance((String)"org.granite.tide.hibernate.HibernatePersistenceManager", (Class[])new Class[]{sfClass, TideTransactionManager.class}, (Object[])new Object[]{sf, tm});
                }
                catch (Exception e) {
                    log.error("Could not setup Hibernate 3 persistence manager, lazy-loading disabled. Check that granite-hibernate.jar is present in the classpath.", new Object[0]);
                    this.pm = new NoPersistenceManager();
                }
                return;
            }
            try {
                Class hibernate4TM = TypeUtil.forName((String)"org.springframework.orm.hibernate4.HibernateTransactionManager");
                if (!hibernate4TM.isInstance(transactionManager)) break block9;
                try {
                    Object sf = transactionManager.getClass().getMethod("getSessionFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
                    Class sfClass = TypeUtil.forName((String)"org.hibernate.SessionFactory");
                    this.pm = (TidePersistenceManager)TypeUtil.newInstance((String)"org.granite.tide.hibernate4.HibernatePersistenceManager", (Class[])new Class[]{sfClass, TideTransactionManager.class}, (Object[])new Object[]{sf, tm});
                }
                catch (Exception e) {
                    log.error("Could not setup Hibernate 4 persistence manager, lazy-loading disabled. Check that granite-hibernate4.jar is present in the classpath.", new Object[0]);
                    this.pm = new NoPersistenceManager();
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        log.error("Unsupported Spring TransactionManager, lazy-loading disabled", new Object[0]);
        this.pm = new NoPersistenceManager();
    }

    public Object attachEntity(Object entity, String[] propertyNames) {
        if (this.pm instanceof AbstractTidePersistenceManager) {
            return ((AbstractTidePersistenceManager)this.pm).attachEntity((TidePersistenceManager)this, entity, propertyNames);
        }
        return this.pm.attachEntity(entity, propertyNames);
    }
}

