/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.granite.tide.data.TideSynchronizationManager;
import org.granite.util.TypeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TideDataPublishingInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(TideDataPublishingInterceptor.class);
    private Gravity gravity;
    private DataUpdatePostprocessor dataUpdatePostprocessor;
    private Map<String, TideSynchronizationManager> syncsMap = new HashMap<String, TideSynchronizationManager>();

    public TideDataPublishingInterceptor() {
        try {
            this.syncsMap.put("org.springframework.orm.hibernate3.SessionHolder", (TideSynchronizationManager)TypeUtil.newInstance((String)"org.granite.tide.spring.Hibernate3SynchronizationManager", TideSynchronizationManager.class));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.syncsMap.put("org.springframework.orm.hibernate4.SessionHolder", (TideSynchronizationManager)TypeUtil.newInstance((String)"org.granite.tide.spring.Hibernate4SynchronizationManager", TideSynchronizationManager.class));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.syncsMap.put("org.springframework.orm.jpa.EntityManagerHolder", (TideSynchronizationManager)TypeUtil.newInstance((String)"org.granite.tide.spring.JPASynchronizationManager", TideSynchronizationManager.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Autowired(required=false)
    public void setDataUpdatePostprocessor(DataUpdatePostprocessor dataUpdatePostprocessor) {
        this.dataUpdatePostprocessor = dataUpdatePostprocessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        block12: {
            DataEnabled dataEnabled = invocation.getThis().getClass().getAnnotation(DataEnabled.class);
            if (dataEnabled == null || !dataEnabled.useInterceptor()) {
                return invocation.proceed();
            }
            boolean shouldRemoveContextAtEnd = DataContext.get() == null;
            boolean shouldInitContext = shouldRemoveContextAtEnd || DataContext.isNull();
            boolean onCommit = false;
            if (shouldInitContext) {
                DataContext.init((Gravity)this.gravity, (String)dataEnabled.topic(), (Class)dataEnabled.params(), (DataEnabled.PublishMode)dataEnabled.publish());
                if (this.dataUpdatePostprocessor != null) {
                    DataContext.get().setDataUpdatePostprocessor(this.dataUpdatePostprocessor);
                }
            }
            DataContext.observe();
            try {
                if (dataEnabled.publish().equals((Object)DataEnabled.PublishMode.ON_COMMIT) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    if (TransactionSynchronizationManager.isSynchronizationActive()) {
                        boolean registered = false;
                        for (Object resource : TransactionSynchronizationManager.getResourceMap().values()) {
                            if (!this.syncsMap.containsKey(resource.getClass().getName())) continue;
                            registered = this.syncsMap.get(resource.getClass().getName()).registerSynchronization(resource, shouldRemoveContextAtEnd);
                            break;
                        }
                        if (!registered) {
                            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new DataPublishingTransactionSynchronization(shouldRemoveContextAtEnd));
                        } else if (shouldRemoveContextAtEnd) {
                            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new DataContextCleanupTransactionSynchronization());
                        }
                        onCommit = true;
                    } else {
                        log.error("Could not register synchronization for ON_COMMIT publish mode, check that the Spring PlatformTransactionManager supports it and that the order of the TransactionInterceptor is lower than the order of TideDataPublishingInterceptor", new Object[0]);
                    }
                }
                Object ret = invocation.proceed();
                DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_SUCCESS);
                object = ret;
                Object var10_10 = null;
                if (!shouldRemoveContextAtEnd || onCommit) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var10_11 = null;
                    if (!shouldRemoveContextAtEnd || onCommit) break block13;
                    DataContext.remove();
                }
                throw throwable;
            }
            DataContext.remove();
        }
        return object;
    }

    private static class DataContextCleanupTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private DataContextCleanupTransactionSynchronization() {
        }

        public void afterCompletion(int status) {
            DataContext.remove();
        }
    }

    private static class DataPublishingTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private boolean removeContext = false;

        public DataPublishingTransactionSynchronization(boolean removeContext) {
            this.removeContext = removeContext;
        }

        public void beforeCommit(boolean readOnly) {
            if (!readOnly) {
                DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_COMMIT);
            }
        }

        public void beforeCompletion() {
            if (this.removeContext) {
                DataContext.remove();
            }
        }

        public void afterCompletion(int status) {
            if (this.removeContext) {
                DataContext.remove();
            }
        }
    }
}

