/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring.data;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.granite.tide.spring.data.FilterMapping;
import org.granite.tide.spring.data.FilterMode;
import org.granite.tide.spring.data.FilterSpecUtil;
import org.springframework.data.jpa.domain.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBeanSpecification<T>
implements Specification<T> {
    private Object filter;

    private FilterBeanSpecification(Object filter) {
        this.filter = filter;
    }

    public static <T> FilterBeanSpecification<T> byBean(Object filter) {
        return new FilterBeanSpecification<T>(filter);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        PropertyDescriptor[] pds = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(this.filter.getClass());
            pds = info.getPropertyDescriptors();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect filter bean", e);
        }
        for (PropertyDescriptor pd : pds) {
            if (pd.getWriteMethod() == null || !pd.getReadMethod().isAnnotationPresent(FilterMapping.class) || pd.getReadMethod().getAnnotation(FilterMapping.class).mode() == FilterMode.EXCLUDE) continue;
            FilterMapping mapping = pd.getReadMethod().getAnnotation(FilterMapping.class);
            if (root.get(mapping.value()) == null) {
                throw new RuntimeException("Invalid filter mapping, path: " + mapping.value());
            }
            Object value = null;
            try {
                value = pd.getReadMethod().invoke(this.filter, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get filter property " + pd.getName(), e);
            }
            Predicate predicate = FilterSpecUtil.buildPredicate(root, builder, pd.getReadMethod().getReturnType(), mapping.value(), value);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        if (predicates.size() > 0) {
            return builder.and(predicates.toArray(new Predicate[predicates.size()]));
        }
        return null;
    }
}

