/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring.data;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.granite.tide.spring.data.FilterMapping;
import org.granite.tide.spring.data.FilterMode;
import org.granite.tide.spring.data.FilterSpecUtil;
import org.springframework.data.jpa.domain.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterExampleSpecification<T>
implements Specification<T> {
    private Metamodel metamodel;
    private Object filter;

    private FilterExampleSpecification(Metamodel metamodel, Object filter) {
        this.metamodel = metamodel;
        this.filter = filter;
    }

    public static <T> FilterExampleSpecification<T> byExample(Metamodel metamodel, Object filter) {
        return new FilterExampleSpecification<T>(metamodel, filter);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.applyAttributes((List<Predicate>)predicates, (Path<?>)root, builder, (ManagedType<?>)this.metamodel.entity(this.filter.getClass()), this.filter);
        if (predicates.size() > 0) {
            return builder.and(predicates.toArray(new Predicate[predicates.size()]));
        }
        return null;
    }

    private void applyAttributes(List<Predicate> predicates, Path<?> root, CriteriaBuilder builder, ManagedType<?> filterType, Object filter) {
        PropertyDescriptor[] pds = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(filter.getClass());
            pds = info.getPropertyDescriptors();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect filter bean", e);
        }
        for (PropertyDescriptor pd : pds) {
            Attribute attribute;
            if (pd.getReadMethod().isAnnotationPresent(FilterMapping.class) && pd.getReadMethod().getAnnotation(FilterMapping.class).mode() == FilterMode.EXCLUDE || (attribute = filterType.getAttribute(pd.getName())) == null) continue;
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                try {
                    Object embedded = pd.getReadMethod().invoke(filter, new Object[0]);
                    if (embedded == null) continue;
                    EmbeddableType embeddedType = this.metamodel.embeddable(attribute.getJavaType());
                    this.applyAttributes(predicates, (Path<?>)root.get(pd.getName()), builder, (ManagedType<?>)embeddedType, embedded);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not get filter property " + pd.getName(), e);
                }
            }
            if (pd.getWriteMethod() == null || attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC) continue;
            Object value = null;
            try {
                value = pd.getReadMethod().invoke(filter, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get filter property " + pd.getName(), e);
            }
            Predicate predicate = FilterSpecUtil.buildPredicate(root, builder, pd.getReadMethod().getReturnType(), pd.getName(), value);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
    }
}

