/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.externalizer
{

import flash.utils.describeType;
import flash.utils.getDefinitionByName;
import flash.utils.Dictionary;
import flash.utils.IDataOutput;
import flash.utils.IDataInput;
import flash.utils.IExternalizable;

import mx.collections.ArrayCollection;
import mx.collections.SortField;
import mx.collections.Sort;

/**
 * Static functions for GDS externalization (roughly based on original code from the author).
 *
 * @author Philippe CHAURANT
 */
public class Externalizer
{

    private static var _cache:Dictionary = new Dictionary( true );

    private static function getOrderedFields( object:Object ):ArrayCollection
    {
        var fields:ArrayCollection = _cache[object.constructor];

        if( fields === null )
        {
            fields = new ArrayCollection();

            var classInfo:XML = describeType( object );
            for each ( var accessor:XML in classInfo..accessor )
                accessor.setName( "variable" );

            for each( var v:XML in classInfo..variable )
            {
                var field:Field = new Field();
                field.fieldName = String( v.@name );
                field.fieldClass = Class( getDefinitionByName( String( v.@type ) ) );
                fields.addItem( field )
            }

            var dataSortField:SortField = new SortField( "fieldName" );
            var dataSort:Sort = new Sort();
            dataSort.fields = [dataSortField];
            fields.sort = dataSort;
            fields.refresh();

            _cache[object.constructor] = fields;
        }

        return fields;

    }

    public static function readExternal( object:IExternalizable, input:IDataInput ):void
    {
        var fields:ArrayCollection = getOrderedFields( object );
        for each( var field:Field in fields )
            object[field.fieldName] = input.readObject() as field.fieldClass;
    }

    public static function writeExternal( object:IExternalizable, output:IDataOutput ):void
    {
        var fields:ArrayCollection = getOrderedFields( object );
        for each( var field:Field in fields )
            output.writeObject( object[field.fieldName] );
    }
}
}

class Field
{
    public var fieldName:String;
    public var fieldClass:Class;
}
