/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2010 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.reflect.visitor
{

import org.granite.reflect.IMember;
import org.granite.reflect.IVisitableElement;

public dynamic class Visitable
{

    private var _parent:Visitable;
    private var _element:IVisitableElement;
    private var _value:*;

    function Visitable( parent:Visitable, element:IVisitableElement, value:* )
    {
        if( element == null )
            throw new ArgumentError( "Parameter element cannot be null" );

        _parent = parent;
        _element = element;
        _value = value;
    }

    public function get parent():Visitable
    {
        return _parent;
    }

    public function get element():IVisitableElement
    {
        return _element;
    }

    public function get value():*
    {
        return _value;
    }

    public function get root():Visitable
    {
        var root:Visitable = this;
        while( root._parent != null )
            root = root._parent;
        return root;
    }

    public function isRoot():Boolean
    {
        return _parent == null;
    }

    public function get path():String
    {
        var path:String = "";

        for( var parent:Visitable = this; parent != null; parent = parent.parent )
        {
            if( parent._element is IMember )
                path = (parent._element as IMember).propertyKey + (path == "" ? "" : "." + path);
        }

        return path;
    }

    public function get property():String
    {
        return (_element is IMember ? (_element as IMember).propertyKey : "");
    }

    public function toString():String
    {
        var s:String;
        try
        {
            s = String( root ) + "(" + path + "=" + String( value ) + ")";
        }
        catch ( e:Error )
        {
            s = e.toString();
        }
        return s;
    }
}
}