/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2010 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.reflect.visitor.handlers
{

import org.granite.reflect.Field;
import org.granite.reflect.Type;
import org.granite.reflect.visitor.IHandler;
import org.granite.reflect.visitor.Visitable;

public class BeanHandler implements IHandler
{

    public function canHandle( visitable:Visitable ):Boolean
    {
        return (visitable.value is Object);
    }

    public function handle( visitable:Visitable, filter:Function ):Array
    {
        var visitables:Array = new Array();

        var type:Type = Type.forInstance( visitable.value );
        for each ( var element:Field in type.properties )
        {
            var value:* = element.getValue( visitable.value );
            var child:Visitable = new Visitable( visitable, element, value );
            if( filter( child ) )
                visitables.push( child );
        }

        return visitables;
    }
}
}