/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.tide
{

import flash.events.EventDispatcher;
import flash.events.TimerEvent;
import flash.net.LocalConnection;
import flash.utils.Dictionary;
import flash.utils.Timer;
import flash.utils.flash_proxy;
import flash.utils.describeType;

import mx.logging.Log;
import mx.logging.ILogger;

import mx.core.ClassFactory;
import mx.collections.IList;
import mx.collections.ItemResponder;
import mx.collections.errors.ItemPendingError;
import mx.rpc.AbstractOperation;
import mx.rpc.AsyncToken;
import mx.rpc.IResponder;
import mx.rpc.events.FaultEvent;
import mx.rpc.events.InvokeEvent;
import mx.rpc.events.ResultEvent;
import mx.utils.ObjectProxy;
import mx.utils.ObjectUtil;
import mx.utils.object_proxy;

use namespace flash_proxy;
use namespace object_proxy;


/**
 *    ComponentFactory is a factory that handles instantiation of components and inject static dependencies
 *
 *     @author William DRAI
 */
[ExcludeClass]
public class ComponentFactory
{

    private static var log:ILogger = Log.getLogger( "org.granite.tide.ComponentFactory" );


    private var _type:Class;
    private var _properties:Object;
    private var _useEmptyConstructor:Boolean = true;


    public function ComponentFactory( type:Class, properties:Object ):void
    {
        _type = type;
        _properties = properties;
        var description:XML = describeType( type )
        if( description..factory..constructor..parameter.(@optional == 'false').length() == 2 )
            _useEmptyConstructor = false;
    }

    public function get type():Class
    {
        return _type;
    }

    public function describe():XML
    {
        return describeType( _type );
    }


    public function newInstance( name:String, context:BaseContext ):*
    {
        var instance:Object = null;
        try
        {
            if( !_useEmptyConstructor )
            {
                try
                {
                    instance = new _type( name, context );
                }
                catch ( e:ArgumentError )
                {
                }
            }
            if( instance == null )
            {
                instance = new _type();

                if( instance is IComponent )
                    IComponent( instance ).meta_init( name, context );
            }
        }
        catch ( e:ArgumentError )
        {
            instance = null;
        }

        if( instance != null && _properties != null )
        {
            for( var p:String in _properties )
            {
                var value:* = _properties[p];
                if( value is String && String( value ).match( /#{.*}/ ) )
                {
                    var val:String = String( value );
                    var prop:String = val.substring( 2, val.length - 1 );
                    var chain:Array = prop.split( "." );
                    value = context;
                    for each ( var c:String in chain )
                        value = value[c];
                }

                instance[p] = value;
            }
        }

        return instance;
    }
}
}
