/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.tide
{

import flash.utils.describeType;
import flash.utils.getQualifiedClassName;
import flash.utils.getQualifiedSuperclassName;

import mx.logging.ILogger;
import mx.logging.Log;
import mx.data.utils.Managed;

import org.granite.meta;


/**
 *     EntityDescriptor contains the definition of entities ([Version] properties for now)
 *
 *     @author William DRAI
 */
[ExcludeClass]
public class EntityDescriptor
{

    private static var log:ILogger = Log.getLogger( "org.granite.tide.EntityDescriptor" );

    public var idPropertyName:String;
    public var versionPropertyName:String;
    public var mergeGDS20:Boolean;
    public var mergeGDS21:Boolean;


    public function EntityDescriptor( entity:IEntity ):void
    {
        var description:XML = describeType( entity );
        var getters:XMLList = description..accessor;
        for each ( var g:XML in getters )
        {
            if( g..metadata.(@name == 'Id').length() > 0 )
                idPropertyName = g.@name.toXMLString();
            if( g..metadata.(@name == 'Version').length() > 0 )
                versionPropertyName = g.@name.toXMLString();
        }

        try
        {
            if( Object( entity ).meta::merge !== undefined )
            {
                mergeGDS21 = true;
                log.debug( "Using GDS 2.1+ meta::merge for entity {0}", getQualifiedClassName( entity ) );
            }
        }
        catch ( e:ReferenceError )
        {
            try
            {
                if( Object( entity ).meta_merge !== undefined )
                {
                    mergeGDS20 = true;
                    log.debug( "Using GDS 2.0 meta_merge for entity {0}", getQualifiedClassName( entity ) );
                }
            }
            catch ( f:ReferenceError )
            {
                // No merge method
                log.debug( "Using defaultMerge for entity {0}", getQualifiedClassName( entity ) );
            }
        }

        if( Managed.entityManagerMode == -1 )
        {
            try
            {
                if( Object( entity ).meta::entityManager !== undefined )
                    Managed.entityManagerMode = Managed.ENTITY_MANAGER_GDS21;
            }
            catch ( e:ReferenceError )
            {
                try
                {
                    if( Object( entity ).meta_getEntityManager !== undefined && Object( entity ).meta_setEntityManager !== undefined )
                        Managed.entityManagerMode = Managed.ENTITY_MANAGER_GDS20;
                }
                catch ( f:ReferenceError )
                {
                    Managed.entityManagerMode = Managed.ENTITY_MANAGER_DICTIONARY;
                }
            }
        }
    }
}
}
