/*
 GRANITE DATA SERVICES
 Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

 This file is part of Granite Data Services.

 Granite Data Services is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or (at your
 option) any later version.

 Granite Data Services is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

package org.granite.tide.validators
{

import mx.logging.Log;
import mx.logging.ILogger;

import mx.validators.Validator;
import mx.validators.ValidationResult;

import mx.data.utils.Managed;

import org.granite.tide.IEntity;
import org.granite.tide.IEntityManager;
import org.granite.tide.events.TideValidatorEvent;


/**
 *     Validator component that listens to TideValidatorEvent coming from server validation
 *  and dispatches them as client validator events
 *
 *     @author William DRAI
 */
public class TideEntityValidator extends Validator
{

    private static var log:ILogger = Log.getLogger( "org.granite.tide.validators.TideEntityValidator" );


    /**
     *     Entity that is tracked for validation errors
     *  The property is defined by the inherited 'property' of the Validator class
     *
     *  @param entity tracked entity
     */
    public function set entity( entity:IEntity ):void
    {
        var em:IEntityManager = source ? Managed.getEntityManager( IEntity( source ) ) : null;
        if( em )
            em.removeEventListener( TideValidatorEvent.INVALID, invalidHandler );

        source = entity;

        if( source )
        {
            em = Managed.getEntityManager( entity );
            if( em )
                em.addEventListener( TideValidatorEvent.INVALID, invalidHandler, false, 0, true );
            else
                log.warn( "trying to setup validator for non managed entity {0}", entity );
        }
    }


    private function invalidHandler( event:TideValidatorEvent ):void
    {
        var invalidValues:Array = event.invalidValues;

        validate( invalidValues );
    }


    override protected function doValidation( value:Object ):Array
    {
        var results:Array = value is String ? super.doValidation( value ) : [];
        if( results.length > 0 )
            return results;

        if( value )
        {
            var em:IEntityManager = Managed.getEntityManager( IEntity( source ) );

            var invalidValues:Array = value as Array;
            for each ( var iv:Object in invalidValues )
            {
                var invalidValue:InvalidValue = iv as InvalidValue;
                if( em.meta_objectEquals( invalidValue.bean, source ) && (property == null || property == invalidValue.path) )
                {
                    var vr:ValidationResult = new ValidationResult( true, invalidValue.path, "invalidValue", invalidValue.message );
                    results.push( vr );
                }
            }
        }

        return results;
    }
}
}