/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.NoSuchEJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.EjbServiceMetadata;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.ejb.InvocationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(EjbServiceContext.class);
    public static final String CAPITALIZED_DESTINATION_ID = "{capitalized.destination.id}";
    public static final String DESTINATION_ID = "{destination.id}";
    private final Map<String, EjbComponent> ejbLookupCache = new ConcurrentHashMap<String, EjbComponent>();
    private final String lookup;

    public EjbServiceContext() throws ServiceException {
        this.lookup = "";
    }

    public EjbServiceContext(String lookup) throws ServiceException {
        this.lookup = lookup;
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public Object findComponent(String componentName) {
        EjbComponent component = this.ejbLookupCache.get(componentName);
        if (component != null) {
            return component.ejbInstance;
        }
        String name = componentName;
        if (this.lookup != null) {
            name = this.lookup;
            if (this.lookup.contains(CAPITALIZED_DESTINATION_ID)) {
                name = this.lookup.replace(CAPITALIZED_DESTINATION_ID, this.capitalize(componentName));
            }
            if (this.lookup.contains(DESTINATION_ID)) {
                name = this.lookup.replace(DESTINATION_ID, componentName);
            }
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
        }
        catch (Exception e) {
            throw new ServiceException("Could not get InitialContext", (Throwable)e);
        }
        this.log.debug(">> New EjbServiceInvoker looking up: %s", new Object[]{name});
        try {
            component = new EjbComponent();
            component.ejbInstance = ic.lookup(name);
            Destination destination = GraniteContext.getCurrentInstance().getServicesConfig().findDestinationById(RemotingMessage.class.getName(), componentName);
            if (destination != null && destination.getScannedClass() != null) {
                component.ejbClass = destination.getScannedClass();
                component.ejbMetadata = new EjbServiceMetadata(destination.getScannedClass(), component.ejbInstance.getClass());
            }
            this.ejbLookupCache.put(componentName, component);
            return component.ejbInstance;
        }
        catch (NamingException e) {
            throw new ServiceException("Could not lookup for: " + name, (Throwable)e);
        }
    }

    public Class<?> findComponentClass(String componentName) {
        EjbComponent component = this.ejbLookupCache.get(componentName);
        if (component == null) {
            this.findComponent(componentName);
        }
        return this.ejbLookupCache.get((Object)componentName).ejbClass;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName) {
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName) {
        EjbComponent component;
        InvocationResult ires = new InvocationResult(result);
        if (componentName != null && (component = this.ejbLookupCache.get(componentName)) != null && component.ejbMetadata.isStateful() && component.ejbMetadata.isRemoveMethod(context.getMethod())) {
            this.ejbLookupCache.remove(componentName);
        }
        return ires;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
        if (componentName != null) {
            EjbComponent component = this.ejbLookupCache.get(componentName);
            if (t instanceof NoSuchEJBException || component.ejbMetadata.isStateful() && component.ejbMetadata.isRemoveMethod(context.getMethod()) && !component.ejbMetadata.getRetainIfException(context.getMethod())) {
                this.ejbLookupCache.remove(componentName);
            }
        }
    }

    private static class EjbComponent {
        public Object ejbInstance;
        public Class<?> ejbClass;
        public EjbServiceMetadata ejbMetadata;

        private EjbComponent() {
        }
    }
}

