/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.tide.TideServiceContext;
import org.granite.tide.TideServiceInvoker;
import org.granite.tide.ejb.EjbServiceContext;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceFactory
extends ServiceFactory {
    private static final long serialVersionUID = 1L;
    private String lookup = null;

    public String getLookup() {
        return this.lookup;
    }

    public void configure(XMap properties) throws ServiceException {
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        if (sServiceExceptionHandler == null) {
            XMap props = new XMap(properties);
            props.put("service-exception-handler", ExtendedServiceExceptionHandler.class.getName());
            super.configure(props);
        } else {
            super.configure(properties);
        }
        this.lookup = properties.get("lookup");
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map cache = context.getSessionMap();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        String key = String.valueOf(TideServiceInvoker.class.getName()) + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        GraniteContext context = GraniteContext.getCurrentInstance();
        Object object = context.getSessionLock();
        synchronized (object) {
            ServiceInvoker invoker = (ServiceInvoker)cache.get(key);
            if (invoker == null) {
                String lookup = this.getLookup();
                if (destination.getProperties().containsKey("lookup")) {
                    lookup = destination.getProperties().get("lookup");
                }
                EjbServiceContext tideContext = new EjbServiceContext(lookup);
                invoker = new TideServiceInvoker(destination, (ServiceFactory)this, (TideServiceContext)tideContext);
                cache.put(key, invoker);
            }
            return invoker;
        }
    }
}

