/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import flex.messaging.io.ArrayCollection;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.granite.config.flex.Channel;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF3Constants;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.DefaultJavaClassDescriptor;
import org.granite.messaging.amf.io.util.IndexedJavaClassDescriptor;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.util.ClassUtil;
import org.granite.util.XMLUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMF3Serializer
extends DataOutputStream
implements ObjectOutput,
AMF3Constants {
    protected static final Logger log = Logger.getLogger(AMF3Serializer.class);
    protected static final Logger logMore = Logger.getLogger(String.valueOf(AMF3Serializer.class.getName()) + "_MORE");
    protected final Map<String, Integer> storedStrings = new HashMap<String, Integer>();
    protected final Map<Object, Integer> storedObjects = new IdentityHashMap<Object, Integer>();
    protected final Map<String, IndexedJavaClassDescriptor> storedClassDescriptors = new HashMap<String, IndexedJavaClassDescriptor>();
    protected final GraniteContext context = GraniteContext.getCurrentInstance();
    protected final Converters converters = this.context.getGraniteConfig().getConverters();
    protected final XMLUtil xmlUtil = new XMLUtil();
    protected final boolean warnOnChannelIdMissing;
    protected final boolean debug;
    protected final boolean debugMore;
    protected Channel channel = null;

    public AMF3Serializer(OutputStream out) {
        this(out, true);
    }

    public AMF3Serializer(OutputStream out, boolean warnOnChannelMissing) {
        super(out);
        this.warnOnChannelIdMissing = warnOnChannelMissing;
        this.debug = log.isDebugEnabled();
        this.debugMore = logMore.isDebugEnabled();
        if (this.debugMore) {
            logMore.debug("new AMF3Serializer(out=%s)", out);
        }
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeObject(o=%s)", o);
        }
        if (o == null) {
            this.write(1);
        } else if (!(o instanceof Externalizable)) {
            if (this.converters.hasReverters()) {
                o = this.converters.revert(o);
            }
            if (o instanceof String || o instanceof Character) {
                this.writeAMF3String(o.toString());
            } else if (o instanceof Boolean) {
                this.write((Boolean)o != false ? 3 : 2);
            } else if (o instanceof Number) {
                if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                    this.writeAMF3Integer(((Number)o).intValue());
                } else {
                    this.writeAMF3Number(((Number)o).doubleValue());
                }
            } else if (o instanceof Date) {
                this.writeAMF3Date((Date)o);
            } else if (o instanceof Calendar) {
                this.writeAMF3Date(((Calendar)o).getTime());
            } else if (o instanceof Document) {
                this.writeAMF3Xml((Document)o);
            } else if (o instanceof Collection) {
                this.writeAMF3Collection((Collection)o);
            } else if (o.getClass().isArray()) {
                if (o.getClass().getComponentType() == Byte.TYPE) {
                    this.writeAMF3ByteArray((byte[])o);
                } else {
                    this.writeAMF3Array(o);
                }
            } else {
                this.writeAMF3Object(o);
            }
        } else {
            this.writeAMF3Object(o);
        }
    }

    protected void writeAMF3Integer(int i) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3Integer(i=%d)", i);
        }
        if (i < -268435456 || i > 0xFFFFFFF) {
            if (this.debugMore) {
                logMore.debug("writeAMF3Integer() - %d is out of AMF3 int range, writing it as a Number", i);
            }
            this.writeAMF3Number(i);
        } else {
            this.write(4);
            this.writeAMF3IntegerData(i);
        }
    }

    protected void writeAMF3IntegerData(int i) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3IntegerData(i=%d)", i);
        }
        if (i < -268435456 || i > 0xFFFFFFF) {
            throw new IllegalArgumentException("Integer out of range: " + i);
        }
        if (i < 0 || i >= 0x200000) {
            this.write(i >> 22 & 0x7F | 0x80);
            this.write(i >> 15 & 0x7F | 0x80);
            this.write(i >> 8 & 0x7F | 0x80);
            this.write(i & 0xFF);
        } else {
            if (i >= 16384) {
                this.write(i >> 14 & 0x7F | 0x80);
            }
            if (i >= 128) {
                this.write(i >> 7 & 0x7F | 0x80);
            }
            this.write(i & 0x7F);
        }
    }

    protected void writeAMF3Number(double d) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3Number(d=%f)", d);
        }
        this.write(5);
        this.writeDouble(d);
    }

    protected void writeAMF3String(String s) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3String(s=%s)", s);
        }
        this.write(6);
        this.writeAMF3StringData(s);
    }

    protected void writeAMF3StringData(String s) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3StringData(s=%s)", s);
        }
        if (s.length() == 0) {
            this.write(1);
            return;
        }
        int index = this.indexOfStoredStrings(s);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            char c;
            this.addToStoredStrings(s);
            int sLength = s.length();
            int uLength = 0;
            int i = 0;
            while (i < sLength) {
                c = s.charAt(i);
                uLength = c >= '\u0001' && c <= '\u007f' ? ++uLength : (c > '\u07ff' ? (uLength += 3) : (uLength += 2));
                ++i;
            }
            this.writeAMF3IntegerData(uLength << 1 | 1);
            i = 0;
            while (i < sLength) {
                c = s.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.write(c);
                } else if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c >> 0 & 0x3F);
                } else {
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
        }
    }

    protected void writeAMF3Xml(Document doc) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3Xml(doc=%s)", doc);
        }
        int xmlType = 11;
        Channel channel = this.getChannel();
        if (channel != null && channel.isLegacyXmlSerialization()) {
            xmlType = 7;
        }
        this.write(xmlType);
        int index = this.indexOfStoredObjects(doc);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(doc);
            byte[] bytes = this.xmlUtil.toString(doc).getBytes("UTF-8");
            this.writeAMF3IntegerData(bytes.length << 1 | 1);
            this.write(bytes);
        }
    }

    protected void writeAMF3Date(Date date) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3Date(date=%s)", date);
        }
        this.write(8);
        int index = this.indexOfStoredObjects(date);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(date);
            this.writeAMF3IntegerData(1);
            this.writeDouble(date.getTime());
        }
    }

    protected void writeAMF3Array(Object array) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3Array(array=%s)", array);
        }
        this.write(9);
        int index = this.indexOfStoredObjects(array);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(array);
            int length = Array.getLength(array);
            this.writeAMF3IntegerData(length << 1 | 1);
            this.write(1);
            int i = 0;
            while (i < length) {
                this.writeObject(Array.get(array, i));
                ++i;
            }
        }
    }

    protected void writeAMF3ByteArray(byte[] bytes) throws IOException {
        if (this.debugMore) {
            logMore.debug("writeAMF3ByteArray(bytes=%s)", new Object[]{bytes});
        }
        this.write(12);
        int index = this.indexOfStoredObjects(bytes);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(bytes);
            this.writeAMF3IntegerData(bytes.length << 1 | 1);
            this.write(bytes);
        }
    }

    protected void writeAMF3Collection(Collection<?> c) throws IOException {
        Channel channel;
        if (this.debugMore) {
            logMore.debug("writeAMF3Collection(c=%s)", c);
        }
        if ((channel = this.getChannel()) != null && channel.isLegacyCollectionSerialization()) {
            this.writeAMF3Array(c.toArray());
        } else {
            ArrayCollection ac = c instanceof ArrayCollection ? (ArrayCollection)c : new ArrayCollection(c);
            this.writeAMF3Object(ac);
        }
    }

    protected void writeAMF3Object(Object o) throws IOException {
        if (this.debug) {
            log.debug("writeAMF3Object(o=%s)...", o);
        }
        this.write(10);
        int index = this.indexOfStoredObjects(o);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            int i;
            this.addToStoredObjects(o);
            ClassGetter classGetter = this.context.getGraniteConfig().getClassGetter();
            if (this.debug) {
                log.debug("writeAMF3Object() - classGetter=%s", classGetter);
            }
            Class<?> oClass = classGetter.getClass(o);
            if (this.debug) {
                log.debug("writeAMF3Object() - oClass=%s", oClass);
            }
            JavaClassDescriptor desc = null;
            IndexedJavaClassDescriptor iDesc = this.getFromStoredClassDescriptors(oClass);
            if (iDesc != null) {
                desc = iDesc.getDescriptor();
                this.writeAMF3IntegerData(iDesc.getIndex() << 2 | 1);
            } else {
                iDesc = this.addToStoredClassDescriptors(oClass);
                desc = iDesc.getDescriptor();
                this.writeAMF3IntegerData(desc.getPropertiesCount() << 4 | desc.getEncoding() << 2 | 3);
                this.writeAMF3StringData(desc.getName());
                i = 0;
                while (i < desc.getPropertiesCount()) {
                    this.writeAMF3StringData(desc.getPropertyName(i));
                    ++i;
                }
            }
            if (this.debug) {
                log.debug("writeAMF3Object() - desc=%s", desc);
            }
            if (desc.isExternalizable()) {
                Externalizer externalizer = desc.getExternalizer();
                if (externalizer != null) {
                    if (this.debug) {
                        log.debug("writeAMF3Object() - using externalizer=%s", externalizer);
                    }
                    try {
                        externalizer.writeExternal(o, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not externalize object: " + o, e);
                    }
                } else {
                    if (this.debug) {
                        log.debug("writeAMF3Object() - legacy Externalizable=%s", o);
                    }
                    ((Externalizable)o).writeExternal(this);
                }
            } else {
                if (this.debug) {
                    log.debug("writeAMF3Object() - writing defined properties...", new Object[0]);
                }
                i = 0;
                while (i < desc.getPropertiesCount()) {
                    Object obj = desc.getPropertyValue(i, o);
                    if (this.debug) {
                        log.debug("writeAMF3Object() - writing defined property: %s=%s", desc.getPropertyName(i), obj);
                    }
                    this.writeObject(obj);
                    ++i;
                }
                if (desc.isDynamic()) {
                    if (this.debug) {
                        log.debug("writeAMF3Object() - writing dynamic properties...", new Object[0]);
                    }
                    Map oMap = (Map)o;
                    for (Map.Entry entry : oMap.entrySet()) {
                        String propertyName;
                        Object key = entry.getKey();
                        if (key == null || (propertyName = key.toString()).length() <= 0) continue;
                        if (this.debug) {
                            log.debug("writeAMF3Object() - writing dynamic property: %s=%s", propertyName, entry.getValue());
                        }
                        this.writeAMF3StringData(propertyName);
                        this.writeObject(entry.getValue());
                    }
                    this.writeAMF3StringData("");
                }
            }
        }
        if (this.debug) {
            log.debug("writeAMF3Object(o=%s) - Done", o);
        }
    }

    protected void addToStoredStrings(String s) {
        if (!this.storedStrings.containsKey(s)) {
            Integer index = this.storedStrings.size();
            if (this.debug) {
                log.debug("addToStoredStrings(s=%s) at index=%d", s, index);
            }
            this.storedStrings.put(s, index);
        }
    }

    protected int indexOfStoredStrings(String s) {
        Integer index = this.storedStrings.get(s);
        if (this.debug) {
            log.debug("indexOfStoredStrings(s=%s) -> %d", s, index != null ? index : -1);
        }
        return index != null ? index : -1;
    }

    protected void addToStoredObjects(Object o) {
        if (o != null && !this.storedObjects.containsKey(o)) {
            Integer index = this.storedObjects.size();
            if (this.debug) {
                log.debug("addToStoredObjects(o=%s) at index=%d", o, index);
            }
            this.storedObjects.put(o, index);
        }
    }

    protected int indexOfStoredObjects(Object o) {
        Integer index = this.storedObjects.get(o);
        if (this.debug) {
            log.debug("indexOfStoredObjects(o=%s) -> %d", o, index != null ? index : -1);
        }
        return index != null ? index : -1;
    }

    protected IndexedJavaClassDescriptor addToStoredClassDescriptors(Class<?> clazz) {
        String name = JavaClassDescriptor.getClassName(clazz);
        if (this.debug) {
            log.debug("addToStoredClassDescriptors(clazz=%s)", clazz);
        }
        if (this.storedClassDescriptors.containsKey(name)) {
            throw new RuntimeException("Descriptor of \"" + name + "\" is already stored at index: " + this.getFromStoredClassDescriptors(clazz).getIndex());
        }
        JavaClassDescriptor desc = null;
        Class<? extends JavaClassDescriptor> descriptorType = this.context.getGraniteConfig().getJavaDescriptor(clazz.getName());
        if (descriptorType != null) {
            Class[] argsDef = new Class[]{Class.class};
            Object[] argsVal = new Object[]{clazz};
            try {
                desc = ClassUtil.newInstance(descriptorType, argsDef, argsVal);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate Java descriptor: " + descriptorType);
            }
        }
        if (desc == null) {
            desc = new DefaultJavaClassDescriptor(clazz);
        }
        IndexedJavaClassDescriptor iDesc = new IndexedJavaClassDescriptor(this.storedClassDescriptors.size(), desc);
        if (this.debug) {
            log.debug("addToStoredClassDescriptors() - putting: name=%s, iDesc=%s", name, iDesc);
        }
        this.storedClassDescriptors.put(name, iDesc);
        return iDesc;
    }

    protected IndexedJavaClassDescriptor getFromStoredClassDescriptors(Class<?> clazz) {
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors(clazz=%s)", clazz);
        }
        String name = JavaClassDescriptor.getClassName(clazz);
        IndexedJavaClassDescriptor iDesc = this.storedClassDescriptors.get(name);
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors() -> %s", iDesc);
        }
        return iDesc;
    }

    protected Channel getChannel() {
        if (this.channel == null) {
            String channelId = this.context.getAMFContext().getChannelId();
            if (channelId != null) {
                this.channel = this.context.getServicesConfig().findChannelById(channelId);
                if (this.channel == null) {
                    log.warn("Could not get channel for channel id: %s", channelId);
                }
            } else if (this.warnOnChannelIdMissing) {
                log.warn("Could not get channel id for message: %s", this.context.getAMFContext().getRequest());
            }
        }
        return this.channel;
    }
}

