/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.ArrayUtil;

public class Array2Array
extends Converter {
    public Array2Array(Converters converters) {
        super(converters);
    }

    protected boolean internalCanConvert(Object value, Type targetType) {
        Type targetComponentType = ArrayUtil.getComponentType(targetType);
        if (targetComponentType == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!value.getClass().isArray()) {
            return false;
        }
        Class<?> oComponentClass = value.getClass().getComponentType();
        if (targetComponentType.equals(oComponentClass)) {
            return true;
        }
        Converter itemConverter = null;
        int length = Array.getLength(value);
        int i = 0;
        while (i < length) {
            Object item = Array.get(value, i);
            if (itemConverter == null) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            } else if (!itemConverter.canConvert(item, targetComponentType)) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            }
            if (itemConverter == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Object internalConvert(Object value, Type targetType) {
        Type targetComponentType;
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() && (targetComponentType = ArrayUtil.getComponentType(targetType)) != null) {
            Class<?> oComponentClass = value.getClass().getComponentType();
            if (targetComponentType.equals(oComponentClass)) {
                return value;
            }
            Converter itemConverter = null;
            int length = Array.getLength(value);
            Object array = ArrayUtil.newArray(targetComponentType, length);
            int i = 0;
            while (i < length) {
                Object item = Array.get(value, i);
                if (itemConverter == null) {
                    itemConverter = this.converters.getConverter(item, targetComponentType);
                } else if (!itemConverter.canConvert(item, targetComponentType)) {
                    itemConverter = this.converters.getConverter(item, targetComponentType);
                }
                if (itemConverter == null) {
                    throw new IllegalConverterArgumentException(this, value, targetType);
                }
                Array.set(array, i, itemConverter.convert(item, targetComponentType));
                ++i;
            }
            return array;
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

