/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodProperty
extends Property {
    private final Method setter;
    private final Method getter;
    private final Type type;

    public MethodProperty(Converters converters, String name, Method setter, Method getter) {
        super(converters, name);
        this.setter = setter;
        this.getter = getter;
        this.type = getter != null ? getter.getGenericReturnType() : setter.getParameterTypes()[0];
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.getter != null && this.getter.isAnnotationPresent(annotationClass)) {
            return true;
        }
        if (this.setter != null) {
            return this.setter.isAnnotationPresent(annotationClass);
        }
        return false;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setProperty(Object instance, Object value, boolean convert) {
        try {
            Object[] params = new Object[]{convert ? this.convert(value) : value};
            this.setter.invoke(instance, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getProperty(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

