/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.entity.PersistenceContextManager;
import org.granite.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TideServiceContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(TideServiceContext.class);
    private String sessionId = null;
    private String entityManagerFactoryJndiName = null;
    private String entityManagerJndiName = null;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void initCall() {
    }

    public abstract Object findComponent(String var1);

    public abstract Class<?> findComponentClass(String var1);

    public abstract void prepareCall(ServiceInvocationContext var1, IInvocationCall var2, String var3);

    public abstract IInvocationResult postCall(ServiceInvocationContext var1, Object var2, String var3);

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
    }

    protected abstract AsyncPublisher getAsyncPublisher();

    public void sendEvent(String componentName) {
        AsyncPublisher publisher = this.getAsyncPublisher();
        if (publisher != null) {
            IInvocationResult eventResult = this.postCall(null, null, componentName);
            publisher.publishMessage(this.sessionId, eventResult);
        }
    }

    public Object mergeExternal(Object obj, Object previous, Map<Object, Object> cache) {
        ITidePersistenceManager pm = this.getTidePersistenceManager(false);
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        return this.mergeExternal(pm, classGetter, obj, previous, cache, null, null);
    }

    public Object mergeExternal(ITidePersistenceManager pm, ClassGetter classGetter, Object obj, Object previous, Map<Object, Object> cache, Object owner, String propertyName) {
        if (obj == null) {
            return null;
        }
        if (pm == null) {
            return obj;
        }
        if (!classGetter.isInitialized(obj)) {
            if (previous != null) {
                return previous;
            }
            return obj;
        }
        Object key = CacheKey.key(obj, owner, propertyName);
        Object prev = cache.get(key);
        Object next = obj;
        if (prev != null) {
            next = prev;
        } else if (obj instanceof Collection) {
            next = this.mergeCollection(pm, classGetter, (Collection)obj, previous, cache, owner, propertyName);
        } else if (obj.getClass().isArray()) {
            next = this.mergeArray(pm, classGetter, obj, previous, cache, owner, propertyName);
        } else if (obj instanceof Map) {
            next = this.mergeMap(pm, classGetter, (Map)obj, previous, cache, owner, propertyName);
        } else if (obj.getClass().isAnnotationPresent(Entity.class)) {
            next = this.mergeEntity(pm, classGetter, obj, previous, cache, owner, propertyName);
        }
        return next;
    }

    private Object mergeEntity(ITidePersistenceManager pm, ClassGetter classGetter, Object obj, Object previous, Map<Object, Object> cache, Object owner, String propertyName) {
        Object dest = obj;
        boolean sameEntity = false;
        if (pm != null) {
            Object p = pm.findEntity(obj);
            if (p != null) {
                previous = p;
                sameEntity = true;
            }
        } else {
            sameEntity = previous.equals(obj);
        }
        if (sameEntity) {
            dest = previous;
        }
        cache.put(CacheKey.key(obj, null, null), dest);
        List<Object[]> fieldValues = classGetter.getFieldValues(obj, dest);
        try {
            for (Object[] fieldValue : fieldValues) {
                Field field = (Field)fieldValue[0];
                Object objv = fieldValue[1];
                Object destv = fieldValue[2];
                objv = this.mergeExternal(pm, classGetter, objv, destv, cache, obj, field.getName());
                field.set(dest, objv);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not merge entity ", e);
        }
        return dest;
    }

    private Object mergeCollection(ITidePersistenceManager pm, ClassGetter classGetter, Collection<Object> coll, Object previous, Map<Object, Object> cache, Object owner, String propertyName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Conversation mergeCollection: " + coll + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Object key = CacheKey.key(coll, owner, propertyName);
        if (previous != null && previous instanceof Collection) {
            cache.put(key, previous);
        } else {
            cache.put(key, coll);
        }
        Collection prevColl = previous instanceof Collection ? (Collection)previous : null;
        ArrayList<Object> addedToColl = new ArrayList<Object>();
        Iterator<Object> icoll = coll.iterator();
        int i = 0;
        while (i < coll.size()) {
            boolean found;
            Object obj = icoll.next();
            if (prevColl instanceof List) {
                found = false;
                List prevList = (List)prevColl;
                int j = 0;
                while (j < prevList.size()) {
                    Object prev = prevList.get(j);
                    if (prev != null && prev.equals(obj)) {
                        obj = this.mergeExternal(pm, classGetter, obj, prev, cache, null, null);
                        if (j != i) {
                            prevList.set(j, prevList.get(i));
                        }
                        prevList.set(i, obj);
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    obj = this.mergeExternal(obj, null, cache);
                    prevColl.add(obj);
                }
            } else if (prevColl != null) {
                found = false;
                Iterator iprevcoll = prevColl.iterator();
                ArrayList<Object> added = new ArrayList<Object>();
                int j = 0;
                while (j < prevColl.size()) {
                    Object prev = iprevcoll.next();
                    if (prev != null && prev.equals(obj)) {
                        if ((obj = this.mergeExternal(obj, prev, cache)) != prev) {
                            if (prevColl instanceof List) {
                                ((List)prevColl).set(j, obj);
                            } else {
                                iprevcoll.remove();
                                added.add(obj);
                            }
                        }
                        found = true;
                    }
                    ++j;
                }
                prevColl.addAll(added);
                if (!found) {
                    obj = this.mergeExternal(obj, null, cache);
                    prevColl.add(obj);
                }
            } else {
                obj = this.mergeExternal(obj, null, cache);
                if (icoll instanceof ListIterator) {
                    ((ListIterator)icoll).set(obj);
                } else {
                    addedToColl.add(obj);
                }
            }
            ++i;
        }
        if (!addedToColl.isEmpty()) {
            coll.addAll(addedToColl);
        }
        if (prevColl != null) {
            Iterator iprevcoll = prevColl.iterator();
            int i2 = 0;
            while (i2 < prevColl.size()) {
                Object obj = iprevcoll.next();
                boolean found = false;
                for (Object next : coll) {
                    if (next == null || !next.equals(obj)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    iprevcoll.remove();
                    --i2;
                }
                ++i2;
            }
            return previous;
        }
        return coll;
    }

    private Object mergeArray(ITidePersistenceManager pm, ClassGetter classGetter, Object array, Object previous, Map<Object, Object> cache, Object owner, String propertyName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Conversation mergeArray: " + array + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Object key = CacheKey.key(array, owner, propertyName);
        int length = Array.getLength(array);
        Object prevArray = ArrayUtil.newArray(ArrayUtil.getComponentType(array.getClass()), length);
        cache.put(key, prevArray);
        int i = 0;
        while (i < length) {
            Object obj = Array.get(array, i);
            Array.set(prevArray, i, this.mergeExternal(pm, classGetter, obj, null, cache, null, null));
            ++i;
        }
        return prevArray;
    }

    private Object mergeMap(ITidePersistenceManager pm, ClassGetter classGetter, Map<Object, Object> map, Object previous, Map<Object, Object> cache, Object owner, String propertyName) {
        Map prevMap;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Conversation mergeMap: " + map + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Object cacheKey = CacheKey.key(map, owner, propertyName);
        if (previous != null && previous instanceof Map) {
            cache.put(cacheKey, previous);
        } else {
            cache.put(cacheKey, map);
        }
        Map map2 = prevMap = previous instanceof Map ? (Map)previous : null;
        if (prevMap != null) {
            if (map != prevMap) {
                prevMap.clear();
                for (Map.Entry<Object, Object> me : map.entrySet()) {
                    Object key = this.mergeExternal(pm, classGetter, me.getKey(), null, cache, null, null);
                    Object value = this.mergeExternal(pm, classGetter, me.getValue(), null, cache, null, null);
                    prevMap.put(key, value);
                }
            }
            return prevMap;
        }
        HashSet<Object[]> addedToMap = new HashSet<Object[]>();
        Iterator<Map.Entry<Object, Object>> ime = map.entrySet().iterator();
        while (ime.hasNext()) {
            Map.Entry<Object, Object> me = ime.next();
            ime.remove();
            Object key = this.mergeExternal(pm, classGetter, me.getKey(), null, cache, null, null);
            Object value = this.mergeExternal(pm, classGetter, me.getValue(), null, cache, null, null);
            addedToMap.add(new Object[]{key, value});
        }
        for (Object[] me : addedToMap) {
            map.put(me[0], me[1]);
        }
        return map;
    }

    public Object lazyInitialize(Object entity, String[] propertyNames) {
        ITidePersistenceManager pm = this.getTidePersistenceManager(true);
        if (pm == null) {
            this.log.warn("No persistence manager found: lazy initialization ignored for " + entity, new Object[0]);
            return entity;
        }
        return pm.attachEntity(entity, propertyNames, true);
    }

    protected ITidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        if (em == null) {
            return null;
        }
        return new PersistenceContextManager(em);
    }

    private EntityManager getEntityManager() {
        block5: {
            try {
                InitialContext jndiContext = new InitialContext();
                if (this.entityManagerFactoryJndiName != null) {
                    EntityManagerFactory factory = (EntityManagerFactory)jndiContext.lookup(this.entityManagerFactoryJndiName);
                    return factory.createEntityManager();
                }
                if (this.entityManagerJndiName != null) {
                    return (EntityManager)jndiContext.lookup(this.entityManagerJndiName);
                }
            }
            catch (NamingException e) {
                if (this.entityManagerFactoryJndiName != null) {
                    throw new RuntimeException("Unable to find a EntityManagerFactory  for jndiName " + this.entityManagerFactoryJndiName);
                }
                if (this.entityManagerJndiName == null) break block5;
                throw new RuntimeException("Unable to find a EntityManager for jndiName " + this.entityManagerJndiName);
            }
        }
        return null;
    }

    public String getEntityManagerFactoryJndiName() {
        return this.entityManagerFactoryJndiName;
    }

    public void setEntityManagerFactoryJndiName(String entityManagerFactoryJndiName) {
        this.entityManagerFactoryJndiName = entityManagerFactoryJndiName;
    }

    public String getEntityManagerJndiName() {
        return this.entityManagerJndiName;
    }

    public void setEntityManagerJndiName(String entityManagerJndiName) {
        this.entityManagerJndiName = entityManagerJndiName;
    }

    public static class CacheKey {
        public static Object key(Object obj, Object owner, String propertyName) {
            if (owner != null && (obj instanceof Collection || obj instanceof Map)) {
                return new CollectionKey(owner, propertyName);
            }
            return obj;
        }
    }

    public static class CollectionKey
    extends CacheKey {
        private Object owner;
        private String propertyName;

        public CollectionKey(Object owner, String propertyName) {
            this.owner = owner;
            this.propertyName = propertyName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(CollectionKey.class)) {
                return false;
            }
            return this.owner.equals(((CollectionKey)obj).owner) && this.propertyName.equals(((CollectionKey)obj).propertyName);
        }

        public int hashCode() {
            return this.owner.hashCode() * 31 + this.propertyName.hashCode();
        }
    }
}

