/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide;

import flex.messaging.messages.RemotingMessage;
import javax.servlet.http.HttpSession;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.TideServiceContext;
import org.granite.tide.validators.EntityValidator;
import org.granite.tide.validators.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideServiceInvoker<T extends ServiceFactory>
extends ServiceInvoker<T> {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(TideServiceInvoker.class);
    public static final String ENTITY_MANAGER_FACTORY_JNDI_NAME = "entityManagerFactoryJndiName";
    public static final String ENTITY_MANAGER_JNDI_NAME = "entityManagerJndiName";
    public static final String VALIDATOR_CLASS_NAME = "validatorClassName";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private TideServiceContext tideContext = null;
    private EntityValidator validator = null;
    private static final InvalidValue[] EMPTY_INVALID_VALUES = new InvalidValue[0];

    public TideServiceInvoker(Destination destination, T factory) throws ServiceException {
        super(destination, factory);
        this.invokee = this;
        this.tideContext = this.lookupContext();
        this.tideContext.initCall();
        this.initValidator();
    }

    public TideServiceInvoker(Destination destination, T factory, TideServiceContext tideContext) throws ServiceException {
        super(destination, factory);
        this.invokee = this;
        this.tideContext = tideContext;
        this.tideContext.initCall();
        this.initValidator();
    }

    public Object initializeObject(Object parent, String[] propertyNames) {
        if (this.destination.getProperties().containsKey(ENTITY_MANAGER_FACTORY_JNDI_NAME)) {
            String jndiName = this.destination.getProperties().get(ENTITY_MANAGER_FACTORY_JNDI_NAME);
            this.tideContext.setEntityManagerFactoryJndiName(jndiName);
        } else if (this.destination.getProperties().containsKey(ENTITY_MANAGER_JNDI_NAME)) {
            String jndiName = this.destination.getProperties().get(ENTITY_MANAGER_JNDI_NAME);
            this.tideContext.setEntityManagerJndiName(jndiName);
        } else {
            throw new RuntimeException("Unable to find entityManagerFactoryJndiName or entityManagerJndiName. Is one of them set in the services config? i.e.<entityManagerFactoryJndiName> or <entityManagerJndiName>");
        }
        return this.tideContext.lazyInitialize(parent, propertyNames);
    }

    private void initValidator() {
        String className = this.destination.getProperties().get(VALIDATOR_CLASS_NAME);
        if (className == null) {
            className = "org.granite.tide.hibernate.HibernateValidator";
        }
        try {
            Class<?> validatorClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            this.validator = (EntityValidator)validatorClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (this.validator == null) {
            this.log.info("Validator class " + className + " not found: validation not enabled", new Object[0]);
        }
    }

    public InvalidValue[] validateObject(Object entity, String propertyName, Object value) {
        if (entity != null && this.validator != null) {
            return this.validator.getPotentialInvalidValues(entity.getClass(), propertyName, value);
        }
        return EMPTY_INVALID_VALUES;
    }

    public void login() {
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpSession session = context.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    protected TideServiceContext lookupContext() {
        return null;
    }

    protected TideServiceContext getTideContext() {
        return this.tideContext;
    }

    @Override
    protected Object adjustInvokee(RemotingMessage request, String methodName, Object[] args) throws ServiceException {
        if ("invokeComponent".equals(methodName)) {
            String componentName = (String)args[0];
            this.log.debug("Setting invokee to {0}", componentName);
            Object instance = this.tideContext.findComponent(componentName);
            Class<?> componentClass = instance != null ? this.tideContext.findComponentClass(componentName) : null;
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (instance != null && context.getGraniteConfig().isComponentTideEnabled(componentName, componentClass, instance)) {
                return instance;
            }
            if (instance != null) {
                this.log.error("SECURITY CHECK: Remote call refused to a non Tide-enabled component: " + componentName + "." + args[1], new Object[0]);
            }
            throw SecurityServiceException.newAccessDeniedException("Component not found");
        }
        return super.adjustInvokee(request, methodName, args);
    }

    @Override
    protected Object[] beforeMethodSearch(Object invokee, String methodName, Object[] args) {
        if ("invokeComponent".equals(methodName)) {
            return new Object[]{args[1], args[2]};
        }
        if ("initializeObject".equals(methodName)) {
            return new Object[]{methodName, new Object[]{args[0], args[1]}};
        }
        if ("validateObject".equals(methodName)) {
            return new Object[]{methodName, new Object[]{args[0], args[1], args[2]}};
        }
        return new Object[]{methodName, EMPTY_ARGS};
    }

    @Override
    protected void beforeInvocation(ServiceInvocationContext context) {
        RemotingMessage message = (RemotingMessage)context.getMessage();
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        Object[] originArgs = (Object[])message.getBody();
        IInvocationCall call = (IInvocationCall)originArgs[originArgs.length - 1];
        String operation = message.getOperation();
        String componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
        graniteContext.getRequestMap().put(TideServiceInvoker.class.getName(), this);
        this.tideContext.prepareCall(context, call, componentName);
    }

    @Override
    protected Object afterInvocation(ServiceInvocationContext context, Object result) {
        Object[] originArgs = (Object[])context.getMessage().getBody();
        String operation = ((RemotingMessage)context.getMessage()).getOperation();
        String componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
        return this.tideContext.postCall(context, result, componentName);
    }

    @Override
    protected void afterInvocationError(ServiceInvocationContext context, Throwable error) {
        Object[] originArgs = (Object[])context.getMessage().getBody();
        String operation = ((RemotingMessage)context.getMessage()).getOperation();
        String componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
        this.tideContext.postCallFault(context, error, componentName);
    }
}

