/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.entity;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Version;
import org.granite.tide.util.Reflections;

public class Entity {
    private Method identifierGetter;
    private Field identifierField;
    private Field versionField;
    private Object wrappedEntity;
    private String name;

    public Entity(Object entity) {
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        if (entity.getClass().isAnnotationPresent(javax.persistence.Entity.class)) {
            this.name = !"".equals(entity.getClass().getAnnotation(javax.persistence.Entity.class).name()) ? entity.getClass().getAnnotation(javax.persistence.Entity.class).name() : entity.getClass().getName();
        }
        this.wrappedEntity = entity;
        Class<?> clazz = entity.getClass();
        while (clazz != Object.class) {
            accessibleObjectArray = clazz.getDeclaredMethods();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                Method method = accessibleObjectArray[n];
                if (method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class)) {
                    this.identifierGetter = method;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (this.identifierGetter == null) {
            clazz = entity.getClass();
            while (clazz != Object.class) {
                accessibleObjectArray = clazz.getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (n < n2) {
                    AccessibleObject field = accessibleObjectArray[n];
                    if (field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class)) {
                        this.identifierField = field;
                        if (!field.isAccessible()) {
                            ((Field)field).setAccessible(true);
                        }
                    }
                    if (field.isAnnotationPresent(Version.class)) {
                        this.versionField = field;
                        if (!field.isAccessible()) {
                            ((Field)field).setAccessible(true);
                        }
                    }
                    ++n;
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    public Object getIdentifier() {
        if (this.identifierGetter != null) {
            return Reflections.invokeAndWrap(this.identifierGetter, this.wrappedEntity, new Object[0]);
        }
        if (this.identifierField != null) {
            return Reflections.getAndWrap(this.identifierField, this.wrappedEntity);
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.wrappedEntity.getClass().getName());
    }

    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    public Field getIdentifierField() {
        return this.identifierField;
    }

    public Field getVersionField() {
        return this.versionField;
    }

    public String getName() {
        return this.name;
    }
}

