/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.entity.Entity;
import org.granite.tide.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextManager
implements ITidePersistenceManager {
    private EntityManager em;
    public static final String USER_TRANSACTION_JNDI = "java:comp/UserTransaction";

    public PersistenceContextManager() {
    }

    public PersistenceContextManager(EntityManager em) {
        this.em = em;
        if (this.em == null) {
            throw new RuntimeException("entity manager is null");
        }
    }

    public PersistenceContextManager(EntityManagerFactory emf) {
        this.em = emf.createEntityManager();
    }

    protected Object beginTransaction() {
        try {
            EntityTransaction et = this.em.getTransaction();
            et.begin();
            return et;
        }
        catch (IllegalStateException e) {
            try {
                InitialContext ic = new InitialContext();
                UserTransaction ut = (UserTransaction)ic.lookup(USER_TRANSACTION_JNDI);
                ut.begin();
                return ut;
            }
            catch (NamingException f) {
                throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
            }
            catch (SystemException f) {
                throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
            }
            catch (NotSupportedException f) {
                throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
            }
        }
    }

    protected void commitTransaction(Object tx) throws Exception {
        if (tx instanceof EntityTransaction) {
            ((EntityTransaction)tx).commit();
        } else if (tx instanceof UserTransaction) {
            ((UserTransaction)tx).commit();
        }
    }

    protected void rollbackTransaction(Object tx) {
        try {
            if (tx instanceof EntityTransaction) {
                ((EntityTransaction)tx).rollback();
            } else if (tx instanceof UserTransaction) {
                ((UserTransaction)tx).rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to rollback attach entity and init collection", e);
        }
    }

    @Override
    public Object attachEntity(Object entity, String[] propertyNames, boolean merge) {
        Object attachedEntity = null;
        ClassGetter getter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Object tx = this.beginTransaction();
        if (tx == null) {
            throw new RuntimeException("Could not initiate transaction for lazy initialization");
        }
        try {
            Object object = attachedEntity = merge ? this.findEntity(entity) : entity;
            if (attachedEntity != null) {
                int i = 0;
                while (i < propertyNames.length) {
                    Object initializedObj = Reflections.getGetterMethod(attachedEntity.getClass(), propertyNames[i]).invoke(attachedEntity, new Object[0]);
                    if (getter != null) {
                        getter.initialize(initializedObj);
                    }
                    ++i;
                }
                if (merge && getter != null) {
                    PersistenceContextManager.reinitialize(attachedEntity, entity, getter, new HashSet<Object>());
                }
            }
            this.commitTransaction(tx);
        }
        catch (Exception e) {
            this.rollbackTransaction(tx);
        }
        return attachedEntity;
    }

    public Object mergeEntity(Object entity) {
        return this.findEntity(entity);
    }

    @Override
    public Object findEntity(Object entity) {
        Entity tideEntity = new Entity(entity);
        Serializable id = (Serializable)tideEntity.getIdentifier();
        if (id == null) {
            return null;
        }
        return this.em.find(entity.getClass(), (Object)id);
    }

    public static void reinitialize(Object attachedEntity, Object entity, ClassGetter getter, Set<Object> cache) {
        if (attachedEntity == null || entity == null || cache.contains(attachedEntity)) {
            return;
        }
        cache.add(attachedEntity);
        if (!getter.isInitialized(entity)) {
            return;
        }
        if (!getter.isInitialized(attachedEntity)) {
            getter.initialize(attachedEntity);
        }
        if (attachedEntity instanceof Collection && entity instanceof Collection) {
            for (Object obj : (Collection)attachedEntity) {
                for (Object prev : (Collection)entity) {
                    if (prev == null || !prev.equals(obj)) continue;
                    PersistenceContextManager.reinitialize(obj, prev, getter, cache);
                }
            }
        } else if (attachedEntity instanceof Map && entity instanceof Map) {
            for (Object obj : ((Map)attachedEntity).keySet()) {
                for (Object prev : ((Map)entity).keySet()) {
                    if (prev == null || !prev.equals(obj)) continue;
                    PersistenceContextManager.reinitialize(obj, prev, getter, cache);
                }
            }
            for (Object obj : ((Map)attachedEntity).values()) {
                for (Object prev : ((Map)entity).values()) {
                    if (prev == null || !prev.equals(obj)) continue;
                    PersistenceContextManager.reinitialize(obj, prev, getter, cache);
                }
            }
        } else if (attachedEntity.getClass().isAnnotationPresent(javax.persistence.Entity.class) && entity.getClass().isAnnotationPresent(javax.persistence.Entity.class)) {
            List<Object[]> fieldValues = getter.getFieldValues(attachedEntity, entity);
            try {
                for (Object[] fieldValue : fieldValues) {
                    Object objv = fieldValue[1];
                    Object destv = fieldValue[2];
                    PersistenceContextManager.reinitialize(objv, destv, getter, cache);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not merge entity ", e);
            }
        }
    }
}

