/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.granite.tide.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static Object invoke(Method method, Object target, Object ... args) throws Exception {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not invoke method by reflection: " + Reflections.toString(method);
            if (args != null && args.length > 0) {
                message = String.valueOf(message) + " with parameters: (" + Strings.toClassNameString(", ", args) + ')';
            }
            message = String.valueOf(message) + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            throw ite;
        }
    }

    public static Object get(Field field, Object target) throws Exception {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not get field value by reflection: " + Reflections.toString(field) + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
    }

    public static void set(Field field, Object target, Object value) throws Exception {
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not set field value by reflection: " + Reflections.toString(field) + " on: " + field.getDeclaringClass().getName();
            message = value == null ? String.valueOf(message) + " with null value" : String.valueOf(message) + " with value: " + value.getClass();
            throw new IllegalArgumentException(message, iae);
        }
    }

    public static Object getAndWrap(Field field, Object target) {
        try {
            return Reflections.get(field, target);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
    }

    public static void setAndWrap(Field field, Object target, Object value) {
        try {
            Reflections.set(field, target, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
    }

    public static Object invokeAndWrap(Method method, Object target, Object ... args) {
        try {
            return Reflections.invoke(method, target, args);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("exception invoking: " + method.getName(), e);
        }
    }

    private static String toString(Method method) {
        return String.valueOf(Strings.unqualify(method.getDeclaringClass().getName())) + '.' + method.getName() + '(' + Strings.toString(", ", method.getParameterTypes()) + ')';
    }

    private static String toString(Field field) {
        return String.valueOf(Strings.unqualify(field.getDeclaringClass().getName())) + '.' + field.getName();
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isClassAvailable(String name) {
        try {
            Reflections.classForName(name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static Class<?> getCollectionElementType(Type collectionType) {
        Type typeArgument;
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type type = typeArgument = typeArguments.length == 1 ? typeArguments[0] : typeArguments[1];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Class<?> getMapKeyType(Type collectionType) {
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Method getSetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1 && Introspector.decapitalize(methodName.substring(3)).equals(name)) {
                return method;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no such setter method: " + clazz.getName() + '.' + name);
    }

    public static Method getGetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.matches("^(get|is).*") && method.getParameterTypes().length == 0) {
                int idx;
                int n3 = idx = methodName.startsWith("get") ? 3 : 2;
                if (Introspector.decapitalize(methodName.substring(idx)).equals(name)) {
                    return method;
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("no such getter method: " + clazz.getName() + '.' + name);
    }

    public static List<Method> getGetterMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(annotation)) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public static Field getField(Class<?> clazz, String name) {
        Class<?> superClass = clazz;
        while (superClass != Object.class) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                superClass = superClass.getSuperclass();
            }
        }
        throw new IllegalArgumentException("no such field: " + clazz.getName() + '.' + name);
    }

    public static List<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> superClass = clazz;
        while (superClass != Object.class) {
            Field[] fieldArray = superClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.isAnnotationPresent(annotation)) {
                    fields.add(field);
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return fields;
    }

    public static Method getMethod(Annotation annotation, String name) {
        try {
            return annotation.annotationType().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class<?> clazz, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Class<?> c = clazz;
        while (c != Object.class) {
            if (name.equals(c.getName())) {
                return true;
            }
            c = c.getSuperclass();
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = classArray[n2];
            if (name.equals(c.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

