/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    public static String unqualify(String name) {
        return Strings.unqualify(name, '.');
    }

    public static String unqualify(String name, char sep) {
        return name.substring(name.lastIndexOf(sep) + 1, name.length());
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String nullIfEmpty(String string) {
        return Strings.isEmpty(string) ? null : string;
    }

    public static String toString(Object component) {
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(component.getClass()).getPropertyDescriptors();
            StringBuilder builder = new StringBuilder();
            PropertyDescriptor[] propertyDescriptorArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                builder.append(descriptor.getName()).append("=").append(descriptor.getReadMethod().invoke(component, new Object[0])).append("; ");
                ++n2;
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String[] split(String strings, String delims) {
        if (strings == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(strings, delims);
        String[] result = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            result[i++] = tokens.nextToken();
        }
        return result;
    }

    public static String toString(Object ... objects) {
        return Strings.toString(" ", objects);
    }

    public static String toString(String sep, Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            builder.append(sep).append(object);
            ++n2;
        }
        return builder.substring(2);
    }

    public static String toClassNameString(String sep, Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            builder.append(sep);
            if (object == null) {
                builder.append("null");
            } else {
                builder.append(object.getClass().getName());
            }
            ++n2;
        }
        return builder.substring(2);
    }

    public static String toString(String sep, Class<?> ... classes) {
        if (classes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            builder.append(sep).append(clazz.getName());
            ++n2;
        }
        return builder.substring(2);
    }

    public static String toString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

