/*
 * Decompiled with CFR 0.152.
 */
package org.granite.toplink;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.IndirectList;
import oracle.toplink.essentials.indirection.IndirectMap;
import oracle.toplink.essentials.indirection.IndirectSet;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.toplink.TopLinkAbstractPersistentCollection;
import org.granite.toplink.TopLinkPersistentList;
import org.granite.toplink.TopLinkPersistentMap;
import org.granite.toplink.TopLinkPersistentSet;
import org.granite.toplink.TopLinkProxy;
import org.granite.toplink.TopLinkProxyInstanciator;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLinkExternalizer
extends DefaultExternalizer {
    private static final Logger log = Logger.getLogger(TopLinkExternalizer.class);

    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class clazz = ClassUtil.forName((String)type);
        if (!this.isRegularEntity(clazz)) {
            return super.newInstance(type, in);
        }
        String laziness = (String)in.readObject();
        if (laziness == null) {
            return super.newInstance(type, in);
        }
        return new TopLinkProxyInstanciator(laziness);
    }

    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (o instanceof TopLinkProxyInstanciator) {
            log.debug("Reading Hibernate Proxy...", new Object[0]);
            ((TopLinkProxyInstanciator)((Object)o)).readId(in);
        } else if (!this.isRegularEntity(o.getClass())) {
            log.debug("Delegating non regular entity reading to DefaultExternalizer...", new Object[0]);
            super.readExternal(o, in);
        } else {
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            ClassGetter classGetter = config.getClassGetter();
            Class oClass = classGetter.getClass(o);
            List fields = this.findOrderedFields(oClass);
            log.debug("Reading entity %s with fields %s", new Object[]{oClass.getName(), fields});
            HashMap<String, Property> topLinkFields = new HashMap<String, Property>();
            for (Property field : fields) {
                if (field.getType() instanceof Class && ValueHolderInterface.class.isAssignableFrom((Class)field.getType())) {
                    topLinkFields.put(field.getName(), field);
                    continue;
                }
                Object value = in.readObject();
                if (value instanceof ValueHolderInterface) {
                    ((Property)topLinkFields.get("_toplink_" + field.getName() + "_vh")).setProperty(o, value, false);
                    continue;
                }
                if (field instanceof MethodProperty && field.isAnnotationPresent(ExternalizedProperty.class)) continue;
                value = value instanceof TopLinkAbstractPersistentCollection ? ((TopLinkAbstractPersistentCollection)value).newInstance(field.getType()) : converters.convert(value, field.getType());
                field.setProperty(o, value, false);
            }
        }
    }

    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Class oClass = classGetter.getClass(o);
        if (o instanceof TopLinkProxy) {
            TopLinkProxy proxy = (TopLinkProxy)o;
            String description = proxy.getProxiedClass().getName();
            log.debug("Writing uninitialized TopLink ValueHolder %s", new Object[]{description});
            out.writeObject(description);
            out.writeObject(null);
            return;
        }
        if (!this.isRegularEntity(o.getClass())) {
            log.debug("Delegating non regular entity writing to DefaultExternalizer...", new Object[0]);
            super.writeExternal(o, out);
        } else {
            out.writeObject(null);
            List fields = this.findOrderedFields(oClass);
            ArrayList<String> lazyFieldNames = new ArrayList<String>();
            log.debug("Writing entity %s with fields %s", new Object[]{o.getClass().getName(), fields});
            for (Property field : fields) {
                if (!(field.getType() instanceof Class) || !ValueHolderInterface.class.isAssignableFrom((Class)field.getType())) {
                    if (lazyFieldNames.contains(field.getName())) {
                        TopLinkProxy proxy = new TopLinkProxy((Class)field.getType());
                        out.writeObject(proxy);
                        continue;
                    }
                    Object value = field.getProperty(o);
                    if (value instanceof IndirectContainer) {
                        if (value instanceof IndirectSet) {
                            value = new TopLinkPersistentSet((IndirectSet)value);
                        } else if (value instanceof IndirectList) {
                            value = new TopLinkPersistentList((IndirectList)value);
                        } else if (value instanceof IndirectMap) {
                            value = new TopLinkPersistentMap((IndirectMap)value);
                        } else {
                            throw new UnsupportedOperationException("Unsupported collection type: " + value);
                        }
                    }
                    out.writeObject(value);
                    continue;
                }
                ValueHolderInterface vh = (ValueHolderInterface)field.getProperty(o);
                if (vh.isInstantiated()) continue;
                lazyFieldNames.add(field.getName().substring("_toplink_".length(), field.getName().length() - 3));
            }
        }
    }

    public int accept(Class<?> clazz) {
        return clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class) || clazz.isAnnotationPresent(Embeddable.class) ? 1 : -1;
    }

    protected boolean isRegularEntity(Class<?> clazz) {
        return clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class);
    }
}

