/*
 * Decompiled with CFR 0.152.
 */
package org.granite.toplink;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.toplink.essentials.indirection.IndirectMap;
import org.granite.toplink.TopLinkAbstractPersistentCollection;
import org.granite.util.ClassUtil;

public class TopLinkPersistentMap
extends TopLinkAbstractPersistentCollection {
    private static final long serialVersionUID = 1L;
    private Object[] content;

    public TopLinkPersistentMap() {
    }

    public TopLinkPersistentMap(IndirectMap value) {
        super(value.getValueHolder().isInstantiated());
        if (this.isInitialized()) {
            this.content = new Object[value.size()];
            int index = 0;
            for (Map.Entry entry : value.entrySet()) {
                this.content[index++] = new Object[]{entry.getKey(), entry.getValue()};
            }
        }
    }

    public Object newInstance(Type target) {
        IndirectMap instance = null;
        boolean sorted = SortedMap.class.isAssignableFrom(ClassUtil.classOfType((Type)target));
        if (this.isInitialized()) {
            if (this.content != null) {
                AbstractMap map = sorted ? new TreeMap() : new HashMap(this.content.length);
                int i = 0;
                while (i < this.content.length) {
                    Object[] e = (Object[])this.content[i];
                    map.put(e[0], e[1]);
                    ++i;
                }
                instance = new IndirectMap(map);
            }
        } else {
            instance = new IndirectMap();
        }
        return instance;
    }

    protected void writeCollectionContent(ObjectOutput out) throws IOException {
        out.writeObject(this.content);
    }

    protected void readCollectionContent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.content = (Object[])in.readObject();
    }
}

