/*
 * Decompiled with CFR 0.152.
 */
package org.granite.toplink;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.toplink.essentials.indirection.IndirectSet;
import org.granite.toplink.TopLinkAbstractPersistentCollection;
import org.granite.util.ClassUtil;

public class TopLinkPersistentSet
extends TopLinkAbstractPersistentCollection {
    private static final long serialVersionUID = 1L;
    private Object[] content;

    public TopLinkPersistentSet() {
    }

    public TopLinkPersistentSet(IndirectSet value) {
        super(value.getValueHolder().isInstantiated());
        if (this.isInitialized()) {
            this.content = value.toArray();
        }
    }

    public Object newInstance(Type target) {
        IndirectSet instance = null;
        boolean sorted = SortedSet.class.isAssignableFrom(ClassUtil.classOfType((Type)target));
        if (this.isInitialized()) {
            if (this.content != null) {
                AbstractSet set = sorted ? new TreeSet() : new HashSet(this.content.length);
                Object[] objectArray = this.content;
                int n = this.content.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    set.add(o);
                    ++n2;
                }
                instance = new IndirectSet(set);
            }
        } else {
            instance = new IndirectSet();
        }
        return instance;
    }

    protected void writeCollectionContent(ObjectOutput out) throws IOException {
        out.writeObject(this.content);
    }

    protected void readCollectionContent(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o != null) {
            this.content = o instanceof Collection ? ((Collection)o).toArray() : (o.getClass().isArray() ? (Object[])o : new Object[]{o});
        }
    }
}

