/*
 * Decompiled with CFR 0.152.
 */
package org.granite.toplink;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.DefaultClassGetter;
import org.granite.toplink.TopLinkProxy;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLinkClassGetter
extends DefaultClassGetter {
    public static final Logger log = Logger.getLogger(TopLinkClassGetter.class);

    public Class<?> getClass(Object o) {
        if (o instanceof ValueHolderInterface) {
            String className;
            ValueHolderInterface holder = (ValueHolderInterface)o;
            String string = className = holder.isInstantiated() ? holder.getValue().getClass().getName() : Object.class.getName();
            if (className != null && className.length() > 0) {
                try {
                    return ClassUtil.forName((String)className);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Could not get class with initializer: %s for: %s", new Object[]{className, className});
                }
            }
            return Object.class;
        }
        if (o instanceof TopLinkProxy) {
            return ((TopLinkProxy)o).getProxiedClass();
        }
        return super.getClass(o);
    }

    public boolean isEntity(Object o) {
        return o.getClass().isAnnotationPresent(Entity.class);
    }

    public boolean isInitialized(Object owner, String propertyName, Object propertyValue) {
        if (propertyValue instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)propertyValue).isInstantiated();
        }
        if (propertyValue instanceof IndirectContainer) {
            return ((IndirectContainer)propertyValue).isInstantiated();
        }
        return true;
    }

    public void initialize(Object owner, String propertyName, Object propertyValue) {
        if (propertyValue instanceof ValueHolderInterface) {
            ((ValueHolderInterface)propertyValue).getValue().toString();
        } else if (propertyValue instanceof IndirectContainer) {
            ((IndirectContainer)propertyValue).getValueHolder().getValue().toString();
        }
    }

    public List<Object[]> getFieldValues(Object obj, Object dest) {
        ArrayList<Object[]> fieldValues = new ArrayList<Object[]>();
        ArrayList<String> topLinkVhs = new ArrayList<String>();
        try {
            for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if ((field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x10) != 0 || (field.getModifiers() & 0x40) != 0 || (field.getModifiers() & 0x100) != 0 || (field.getModifiers() & 0x80) != 0) continue;
                    if (ValueHolderInterface.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        ValueHolderInterface vh = (ValueHolderInterface)field.get(obj);
                        if (vh.isInstantiated()) continue;
                        topLinkVhs.add(field.getName());
                        field.set(dest, vh);
                        continue;
                    }
                    if (topLinkVhs.contains("_toplink_" + field.getName() + "_vh")) continue;
                    field.setAccessible(true);
                    Object o = field.get(obj);
                    Object d = field.get(dest);
                    fieldValues.add(new Object[]{field, o, d});
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not merge entity ", e);
        }
        return fieldValues;
    }
}

