/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet6AddressConverter
implements Converter<Inet6Address> {
    @Override
    public Inet6Address convertFrom(String value) {
        Inet6Address result;
        try {
            if (null == value) {
                throw new NullPointerException("value must not be null!");
            }
            InetAddress inetAddress = InetAddress.getByName(value);
            if (!(inetAddress instanceof Inet6Address)) {
                throw new UnknownHostException(value);
            }
            result = (Inet6Address)inetAddress;
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Inet6Address.", ex);
        }
        return result;
    }

    @Override
    public String convertTo(Inet6Address value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value.getHostAddress();
    }
}

