/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.Locale;

public class LocaleConverter
implements Converter<Locale> {
    @Override
    public Locale convertFrom(String value) {
        Locale result = this.getLocale(value);
        if (null == result) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Locale");
        }
        return result;
    }

    private Locale getLocale(String languageTag) {
        if (null == languageTag) {
            return null;
        }
        String[] components = languageTag.split("_", 3);
        switch (components.length) {
            case 1: {
                return new Locale(components[0]);
            }
            case 2: {
                return new Locale(components[0], components[1]);
            }
            case 3: {
                return new Locale(components[0], components[1], components[2]);
            }
        }
        return null;
    }

    @Override
    public String convertTo(Locale value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value.toString();
    }
}

