/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class StringSortedSetConverter
implements Converter<SortedSet<String>> {
    protected static final String DELIMITER = ",";

    @Override
    public SortedSet<String> convertFrom(String value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to sorted set of String.");
        }
        if ("".equals(value)) {
            return new TreeSet<String>();
        }
        TreeSet<String> result = new TreeSet<String>();
        Collections.addAll(result, value.split(DELIMITER));
        return result;
    }

    @Override
    public String convertTo(SortedSet<String> value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (String element : value) {
            sb.append(separator);
            sb.append(element);
            separator = DELIMITER;
        }
        return sb.toString();
    }
}

