/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Seconds;

public class SecondsConverter
implements Converter<Seconds> {
    @Override
    public Seconds convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Seconds.parseSeconds((String)trimmed);
            }
            int seconds = Integer.parseInt(trimmed);
            return Seconds.seconds((int)seconds);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Seconds.", ex);
        }
    }

    @Override
    public String convertTo(Seconds value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getSeconds());
    }
}

