/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Weeks;

public class WeeksConverter
implements Converter<Weeks> {
    @Override
    public Weeks convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Weeks.parseWeeks((String)trimmed);
            }
            int weeks = Integer.parseInt(trimmed);
            return Weeks.weeks((int)weeks);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Weeks.", ex);
        }
    }

    @Override
    public String convertTo(Weeks value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getWeeks());
    }
}

