/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Years;

public class YearsConverter
implements Converter<Years> {
    @Override
    public Years convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Years.parseYears((String)trimmed);
            }
            int years = Integer.parseInt(trimmed);
            return Years.years((int)years);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Years.", ex);
        }
    }

    @Override
    public String convertTo(Years value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getYears());
    }
}

