/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig;

import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.response.ProcessingOutcome;
import com.github.joschi.jadconfig.response.ProcessingResponse;
import java.util.LinkedList;
import java.util.stream.Stream;

public class LazyValidationException
extends ValidationException {
    private final ProcessingResponse processingResponse;

    public LazyValidationException(ProcessingResponse result) {
        super(LazyValidationException.toMessage(result));
        this.processingResponse = result;
    }

    private static String toMessage(ProcessingResponse result) {
        LinkedList<String> stringBuilder = new LinkedList<String>();
        stringBuilder.add("Following errors ocurred during configuration processing:");
        result.getOutcomes().stream().filter(ProcessingOutcome::hasProblems).flatMap(processingOutcome -> Stream.concat(processingOutcome.getFieldProcessingProblems().values().stream().map(Throwable::getMessage), processingOutcome.getValidationMethodsProblems().values().stream().map(Throwable::getMessage))).forEach(stringBuilder::add);
        return String.join((CharSequence)"\n", stringBuilder);
    }

    public ProcessingResponse getProcessingResponse() {
        return this.processingResponse;
    }
}

