/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet4AddressConverter
implements Converter<Inet4Address> {
    @Override
    public Inet4Address convertFrom(String value) {
        Inet4Address result;
        try {
            if (null == value) {
                throw new NullPointerException("value must not be null!");
            }
            InetAddress inetAddress = InetAddress.getByName(value);
            if (!(inetAddress instanceof Inet4Address)) {
                throw new UnknownHostException(value);
            }
            result = (Inet4Address)inetAddress;
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Inet4Address.", ex);
        }
        return result;
    }

    @Override
    public String convertTo(Inet4Address value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value.getHostAddress();
    }
}

