/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StringSetConverter
implements Converter<Set<String>> {
    protected static final String DELIMITER = ",";

    @Override
    public Set<String> convertFrom(String value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to set of String.");
        }
        if ("".equals(value)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, value.split(DELIMITER));
        return result;
    }

    @Override
    public String convertTo(Set<String> value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (String element : value) {
            sb.append(separator);
            sb.append(element);
            separator = DELIMITER;
        }
        return sb.toString();
    }
}

