/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.documentation;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ReflectionUtils;
import com.github.joschi.jadconfig.documentation.ConfigurationBeansSPI;
import com.github.joschi.jadconfig.documentation.ConfigurationEntry;
import com.github.joschi.jadconfig.documentation.ConfigurationEntryWithSection;
import com.github.joschi.jadconfig.documentation.Documentation;
import com.github.joschi.jadconfig.documentation.DocumentationFormat;
import com.github.joschi.jadconfig.documentation.DocumentationSection;
import com.github.joschi.jadconfig.documentation.printers.ConfigFileDocsPrinter;
import com.github.joschi.jadconfig.documentation.printers.ConfigurationSection;
import com.github.joschi.jadconfig.documentation.printers.CsvDocsPrinter;
import com.github.joschi.jadconfig.documentation.printers.DocsPrinter;
import jakarta.annotation.Nonnull;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;

public class ConfigurationDocsGenerator {
    public static void main(String[] args) throws IOException {
        ConfigurationDocsGenerator generator = new ConfigurationDocsGenerator();
        generator.generateDocumentation(ConfigurationDocsGenerator.parseDocumentationFormat(args), ConfigurationBeansSPI::loadConfigurationBeans);
    }

    @Nonnull
    private static DocumentationFormat parseDocumentationFormat(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("This command needs two arguments - a format and file path. For examplecsv ${project.build.directory}/configuration-documentation.csv");
        }
        String format = args[0].toLowerCase(Locale.ROOT).trim();
        String file = args[1];
        return new DocumentationFormat(format, file);
    }

    public void generateDocumentation(DocumentationFormat format, Supplier<List<Object>> configurationBeans) throws IOException {
        List<ConfigurationSection> sections = this.detectConfigurationSections(configurationBeans);
        try (DocsPrinter writer = this.createWriter(format);){
            writer.write(sections);
        }
    }

    private DocsPrinter createWriter(DocumentationFormat format) throws IOException {
        FileWriter fileWriter = new FileWriter(format.outputFile(), StandardCharsets.UTF_8);
        return switch (format.format()) {
            case "csv" -> new CsvDocsPrinter(fileWriter);
            case "conf" -> new ConfigFileDocsPrinter(fileWriter);
            default -> throw new IllegalArgumentException("Unsupported format " + format.format());
        };
    }

    private List<ConfigurationSection> detectConfigurationSections(Supplier<List<Object>> configurationBeans) {
        return configurationBeans.get().stream().map(ConfigurationDocsGenerator::beanToConfigSections).sorted(Comparator.comparing(ConfigurationSection::hasPriority).reversed()).toList();
    }

    private static ConfigurationSection beanToConfigSections(Object configurationBean) {
        String sectionHeading = null;
        String sectionDescription = null;
        if (configurationBean.getClass().isAnnotationPresent(DocumentationSection.class)) {
            DocumentationSection documentationSection = configurationBean.getClass().getAnnotation(DocumentationSection.class);
            sectionHeading = documentationSection.heading();
            sectionDescription = documentationSection.description();
        }
        List<ConfigurationEntryWithSection> entries = Arrays.stream(configurationBean.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Parameter.class)).filter(ConfigurationDocsGenerator::isPublicFacing).map(f -> ConfigurationDocsGenerator.toConfigurationEntry(f, configurationBean)).toList();
        List<ConfigurationEntry> entriesWithoutSection = ConfigurationDocsGenerator.getEntriesWithoutSection(entries);
        List<ConfigurationSection> sortedSections = ConfigurationDocsGenerator.sectionsFromEntries(entries);
        return new ConfigurationSection(sectionHeading, sectionDescription, sortedSections, entriesWithoutSection);
    }

    @Nonnull
    private static List<ConfigurationSection> sectionsFromEntries(List<ConfigurationEntryWithSection> entries) {
        return entries.stream().filter(ConfigurationEntryWithSection::hasSection).collect(ConfigurationDocsGenerator.groupBySection()).values().stream().sorted(ConfigurationDocsGenerator.sortByPriority()).toList();
    }

    private static Comparator<ConfigurationSection> sortByPriority() {
        return Comparator.comparing(ConfigurationSection::hasPriority, Comparator.reverseOrder());
    }

    private static Collector<ConfigurationEntryWithSection, ?, Map<String, ConfigurationSection>> groupBySection() {
        return Collectors.groupingBy(ConfigurationEntryWithSection::sectionHeading, Collectors.collectingAndThen(Collectors.toList(), ConfigurationDocsGenerator::toConfigurationSection));
    }

    private static ConfigurationSection toConfigurationSection(List<ConfigurationEntryWithSection> list) {
        ConfigurationEntryWithSection section = (ConfigurationEntryWithSection)list.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No configuration section found but expected!"));
        List<ConfigurationEntry> entries = list.stream().map(ConfigurationEntryWithSection::entry).collect(Collectors.toList());
        return new ConfigurationSection(section.sectionHeading(), section.sectionDescription(), Collections.emptyList(), entries);
    }

    @Nonnull
    private static List<ConfigurationEntry> getEntriesWithoutSection(List<ConfigurationEntryWithSection> entries) {
        return entries.stream().filter(e -> !e.hasSection()).map(ConfigurationEntryWithSection::entry).sorted(Comparator.comparing(ConfigurationEntry::hasPriority, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    private static boolean isPublicFacing(Field f) {
        return !f.isAnnotationPresent(Documentation.class) || f.getAnnotation(Documentation.class).visible();
    }

    private static ConfigurationEntryWithSection toConfigurationEntry(Field f, Object instance) {
        String documentation = Optional.ofNullable(f.getAnnotation(Documentation.class)).map(Documentation::value).orElse(null);
        Parameter parameter = f.getAnnotation(Parameter.class);
        String propertyName = parameter.value();
        Object defaultValue = ConfigurationDocsGenerator.getDefaultValue(f, instance);
        String type = ConfigurationDocsGenerator.getType(f);
        boolean required = parameter.required();
        DocumentationSection documentationSection = f.getAnnotation(DocumentationSection.class);
        String sectionHeading = null;
        String sectionDescription = null;
        if (documentationSection != null) {
            sectionHeading = documentationSection.heading();
            sectionDescription = documentationSection.description();
        }
        ConfigurationEntry entry = new ConfigurationEntry(instance.getClass(), f.getName(), type, propertyName, defaultValue, required, documentation);
        return new ConfigurationEntryWithSection(entry, sectionHeading, sectionDescription);
    }

    private static Object getDefaultValue(Field f, Object instance) {
        try {
            return ReflectionUtils.getFieldValue(instance, f);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getType(Field f) {
        if (f.getType().isPrimitive()) {
            return ClassUtils.primitiveToWrapper(f.getType()).getSimpleName();
        }
        return f.getType().getSimpleName();
    }
}

