/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.documentation.printers;

import com.github.joschi.jadconfig.documentation.ConfigurationEntry;
import com.github.joschi.jadconfig.documentation.printers.ConfigurationSection;
import com.github.joschi.jadconfig.documentation.printers.DocsPrinter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileDocsPrinter
implements DocsPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileDocsPrinter.class);
    private final OutputStreamWriter writer;

    public ConfigFileDocsPrinter(OutputStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(List<ConfigurationSection> configurationSections) {
        configurationSections.forEach(section -> this.doWriteSection((ConfigurationSection)section, 1));
    }

    private void doWriteSection(ConfigurationSection configurationSection, int level) {
        this.heading(configurationSection.heading(), level).ifPresent(this::append);
        this.description(configurationSection.description()).ifPresent(this::append);
        configurationSection.entries().stream().map(this::fieldToString).forEach(this::append);
        configurationSection.sections().forEach(section -> this.doWriteSection((ConfigurationSection)section, level + 1));
    }

    private Optional<String> description(String description) {
        return Optional.ofNullable(description).map(text -> text.lines().map(l -> "# " + l.trim()).collect(Collectors.joining("\n"))).map(text -> text + "\n\n");
    }

    private void append(String formatted) {
        try {
            this.writer.append(formatted);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> heading(String heading, int level) {
        return Optional.ofNullable(heading).map(h -> ConfigFileDocsPrinter.headingTemplate(level).formatted(heading));
    }

    private static String headingTemplate(int level) {
        if (level == 1) {
            return "#####################################\n# %s\n#####################################\n";
        }
        return "#### %s\n";
    }

    private String fieldToString(ConfigurationEntry field) {
        boolean forceFillIn = field.required() && field.defaultValue() == null;
        String template = "%s\n%s%s = %s\n\n";
        return String.format(Locale.ROOT, template, ConfigFileDocsPrinter.formatDocumentation(field), forceFillIn ? "" : "#", field.configName(), this.wrapValue(field.defaultValue()));
    }

    private String wrapValue(Object value) {
        return Optional.ofNullable(value).map(String::valueOf).orElse("");
    }

    private static String formatDocumentation(ConfigurationEntry field) {
        String[] lines = Optional.ofNullable(field.documentation()).orElse("").split("\n");
        return Arrays.stream(lines).map(String::trim).peek(line -> {
            if (line.length() > 120) {
                LOG.warn("Documentation line of " + field.configurationBean().getName() + "." + field.fieldName() + " too long, consider splitting into more lines: " + WordUtils.abbreviate((String)line, (int)120, (int)130, (String)"..."));
            }
        }).map(line -> "# " + line).collect(Collectors.joining("\n"));
    }
}

