/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.documentation.printers;

import com.github.joschi.jadconfig.documentation.ConfigurationEntry;
import com.github.joschi.jadconfig.documentation.printers.ConfigurationSection;
import com.github.joschi.jadconfig.documentation.printers.DocsPrinter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.BooleanUtils;

public class CsvDocsPrinter
implements DocsPrinter {
    public static final String HEADER_PARAMETER = "Parameter";
    public static final String HEADER_TYPE = "Type";
    public static final String HEADER_REQUIRED = "Required";
    public static final String HEADER_DEFAULT_VALUE = "Default value";
    public static final String HEADER_DESCRIPTION = "Description";
    public static final String[] HEADERS = new String[]{"Parameter", "Type", "Required", "Default value", "Description"};
    private final CSVPrinter csvPrinter;

    public CsvDocsPrinter(OutputStreamWriter streamWriter) throws IOException {
        this.csvPrinter = new CSVPrinter((Appendable)streamWriter, CSVFormat.EXCEL);
    }

    @Override
    public void write(List<ConfigurationSection> sections) {
        this.printHeaders();
        sections.forEach(this::doWriteSection);
    }

    private void printHeaders() {
        try {
            this.csvPrinter.printRecord((Object[])HEADERS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doWriteSection(ConfigurationSection section) {
        section.entries().forEach(this::writeField);
        section.sections().forEach(this::doWriteSection);
    }

    private void writeField(ConfigurationEntry f) {
        try {
            this.csvPrinter.printRecord(new Object[]{f.configName(), f.type(), BooleanUtils.toStringYesNo((boolean)f.required()), f.defaultValue(), f.documentation()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.csvPrinter.close();
    }

    @Override
    public void flush() throws IOException {
        this.csvPrinter.flush();
    }
}

