/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Months;

public class MonthsConverter
implements Converter<Months> {
    @Override
    public Months convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Months.parseMonths((String)value);
            }
            int months = Integer.parseInt(value);
            return Months.months((int)months);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Months.", ex);
        }
    }

    @Override
    public String convertTo(Months value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getMonths());
    }
}

