/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.repositories;

import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;

public class EnvironmentRepository
implements Repository {
    private final String prefix;
    private final boolean upperCase;

    public EnvironmentRepository() {
        this("");
    }

    public EnvironmentRepository(String prefix) {
        this(prefix, true);
    }

    public EnvironmentRepository(boolean upperCase) {
        this("", upperCase);
    }

    public EnvironmentRepository(String prefix, boolean upperCase) {
        this.prefix = prefix;
        this.upperCase = upperCase;
    }

    @Override
    public void open() throws RepositoryException {
    }

    @Override
    public String read(String name) {
        Object envName = this.upperCase ? (this.prefix + name).toUpperCase() : this.prefix + name;
        return System.getenv((String)envName);
    }

    @Override
    public void close() throws RepositoryException {
    }

    public int size() {
        return System.getenv().size();
    }
}

