/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.com.sun.mail.pop3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.graylog.shaded.kafka09.com.sun.mail.pop3.POP3Folder;
import org.graylog.shaded.kafka09.com.sun.mail.pop3.POP3Store;
import org.graylog.shaded.kafka09.javax.mail.Flags;
import org.graylog.shaded.kafka09.javax.mail.Folder;
import org.graylog.shaded.kafka09.javax.mail.FolderClosedException;
import org.graylog.shaded.kafka09.javax.mail.IllegalWriteException;
import org.graylog.shaded.kafka09.javax.mail.MessageRemovedException;
import org.graylog.shaded.kafka09.javax.mail.MessagingException;
import org.graylog.shaded.kafka09.javax.mail.internet.InternetHeaders;
import org.graylog.shaded.kafka09.javax.mail.internet.MimeMessage;
import org.graylog.shaded.kafka09.javax.mail.internet.SharedInputStream;

public class POP3Message
extends MimeMessage {
    static final String UNKNOWN = "UNKNOWN";
    private POP3Folder folder;
    private int hdrSize = -1;
    private int msgSize = -1;
    String uid = "UNKNOWN";

    public POP3Message(Folder folder, int msgno) throws MessagingException {
        super(folder, msgno);
        this.folder = (POP3Folder)folder;
    }

    public void setFlags(Flags newFlags, boolean set) throws MessagingException {
        Flags oldFlags = (Flags)this.flags.clone();
        super.setFlags(newFlags, set);
        if (!this.flags.equals(oldFlags)) {
            this.folder.notifyMessageChangedListeners(1, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws MessagingException {
        if (this.msgSize >= 0) {
            return this.msgSize;
        }
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.msgSize < 0) {
                    if (this.headers == null) {
                        this.loadHeaders();
                    }
                    this.msgSize = this.contentStream != null ? this.contentStream.available() : this.folder.getProtocol().list(this.msgnum) - this.hdrSize;
                }
                return this.msgSize;
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error getting size", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContentStream() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.contentStream == null) {
                    InputStream rawcontent = this.folder.getProtocol().retr(this.msgnum, this.msgSize > 0 ? this.msgSize + this.hdrSize : 0);
                    if (rawcontent == null) {
                        this.expunged = true;
                        throw new MessageRemovedException();
                    }
                    if (this.headers == null || ((POP3Store)this.folder.getStore()).forgetTopHeaders) {
                        this.headers = new InternetHeaders(rawcontent);
                        this.hdrSize = (int)((SharedInputStream)((Object)rawcontent)).getPosition();
                    } else {
                        int len;
                        boolean offset = false;
                        block6: do {
                            int c1;
                            len = 0;
                            while ((c1 = rawcontent.read()) >= 0 && c1 != 10) {
                                if (c1 == 13) {
                                    if (rawcontent.available() <= 0) continue block6;
                                    rawcontent.mark(1);
                                    if (rawcontent.read() == 10) continue block6;
                                    rawcontent.reset();
                                    continue block6;
                                }
                                ++len;
                            }
                        } while (rawcontent.available() != 0 && len != 0);
                        this.hdrSize = (int)((SharedInputStream)((Object)rawcontent)).getPosition();
                    }
                    this.contentStream = ((SharedInputStream)((Object)rawcontent)).newStream(this.hdrSize, -1L);
                    Object var2_4 = null;
                }
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error fetching POP3 content", ex);
        }
        return super.getContentStream();
    }

    public void invalidate(boolean invalidateHeaders) {
        this.content = null;
        this.contentStream = null;
        this.msgSize = -1;
        if (invalidateHeaders) {
            this.headers = null;
            this.hdrSize = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream top(int n) throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                return this.folder.getProtocol().top(this.msgnum, n);
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error getting size", ex);
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void addHeader(String name, String value2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void removeHeader(String name) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeaders() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.headers != null) {
                    return;
                }
                InputStream hdrs = null;
                if (((POP3Store)this.folder.getStore()).disableTop || (hdrs = this.folder.getProtocol().top(this.msgnum, 0)) == null) {
                    InputStream cs = this.getContentStream();
                    cs.close();
                } else {
                    this.hdrSize = hdrs.available();
                    this.headers = new InternetHeaders(hdrs);
                }
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error loading POP3 headers", ex);
        }
    }
}

