/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.javax.mail.internet;

import org.graylog.shaded.kafka09.javax.mail.internet.HeaderTokenizer;
import org.graylog.shaded.kafka09.javax.mail.internet.ParameterList;
import org.graylog.shaded.kafka09.javax.mail.internet.ParseException;

public class ContentDisposition {
    private String disposition;
    private ParameterList list;

    public ContentDisposition() {
    }

    public ContentDisposition(String disposition, ParameterList list2) {
        this.disposition = disposition;
        this.list = list2;
    }

    public ContentDisposition(String s2) throws ParseException {
        HeaderTokenizer h = new HeaderTokenizer(s2, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token tk = h.next();
        if (tk.getType() != -1) {
            throw new ParseException();
        }
        this.disposition = tk.getValue();
        String rem = h.getRemainder();
        if (rem != null) {
            this.list = new ParameterList(rem);
        }
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getParameter(String name) {
        if (this.list == null) {
            return null;
        }
        return this.list.get(name);
    }

    public ParameterList getParameterList() {
        return this.list;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setParameter(String name, String value2) {
        if (this.list == null) {
            this.list = new ParameterList();
        }
        this.list.set(name, value2);
    }

    public void setParameterList(ParameterList list2) {
        this.list = list2;
    }

    public String toString() {
        if (this.disposition == null) {
            return null;
        }
        if (this.list == null) {
            return this.disposition;
        }
        StringBuffer sb = new StringBuffer(this.disposition);
        sb.append(this.list.toString(sb.length() + 21));
        return sb.toString();
    }
}

