/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.kafka.coordinator;

import java.util.UUID;
import org.graylog.shaded.kafka09.kafka.coordinator.AwaitingSync$;
import org.graylog.shaded.kafka09.kafka.coordinator.Dead$;
import org.graylog.shaded.kafka09.kafka.coordinator.GroupCoordinator$;
import org.graylog.shaded.kafka09.kafka.coordinator.GroupMetadata$;
import org.graylog.shaded.kafka09.kafka.coordinator.GroupOverview;
import org.graylog.shaded.kafka09.kafka.coordinator.GroupState;
import org.graylog.shaded.kafka09.kafka.coordinator.GroupSummary;
import org.graylog.shaded.kafka09.kafka.coordinator.MemberMetadata;
import org.graylog.shaded.kafka09.kafka.coordinator.MemberSummary;
import org.graylog.shaded.kafka09.kafka.coordinator.PreparingRebalance$;
import org.graylog.shaded.kafka09.kafka.coordinator.Stable$;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.GenTraversable;
import org.graylog.shaded.kafka09.scala.collection.Iterable$;
import org.graylog.shaded.kafka09.scala.collection.LinearSeqOptimized;
import org.graylog.shaded.kafka09.scala.collection.SetLike;
import org.graylog.shaded.kafka09.scala.collection.TraversableLike;
import org.graylog.shaded.kafka09.scala.collection.TraversableOnce;
import org.graylog.shaded.kafka09.scala.collection.immutable.List;
import org.graylog.shaded.kafka09.scala.collection.immutable.List$;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.collection.immutable.Set;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.HashMap;
import org.graylog.shaded.kafka09.scala.collection.mutable.HashMap$;
import org.graylog.shaded.kafka09.scala.math.Ordering$Int$;
import org.graylog.shaded.kafka09.scala.reflect.ScalaSignature;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dx!B\u0001\u0003\u0011\u00139\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tAIa\u0003\u0002\u000e\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00139\u0012a\u0005<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001cX#\u0001\r\u0011\tearD\t\b\u0003\u001biI!a\u0007\b\u0002\rA\u0013X\rZ3g\u0013\tibDA\u0002NCBT!a\u0007\b\u0011\u0005!\u0001\u0013BA\u0011\u0003\u0005)9%o\\;q'R\fG/\u001a\t\u00043\rz\u0012B\u0001\u0013\u001f\u0005\r\u0019V\r\u001e\u0005\u0007M%\u0001\u000b\u0011\u0002\r\u0002)Y\fG.\u001b3Qe\u00164\u0018n\\;t'R\fG/Z:!\r\u0015Q!\u0001\u0001\u0002)'\t9C\u0002\u0003\u0005+O\t\u0015\r\u0011\"\u0001,\u0003\u001d9'o\\;q\u0013\u0012,\u0012\u0001\f\t\u000335J!A\f\u0010\u0003\rM#(/\u001b8h\u0011!\u0001tE!A!\u0002\u0013a\u0013\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u0011I:#Q1A\u0005\u0002-\nA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016D\u0001\u0002N\u0014\u0003\u0002\u0003\u0006I\u0001L\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u000bM9C\u0011\u0001\u001c\u0015\u0007]B\u0014\b\u0005\u0002\tO!)!&\u000ea\u0001Y!)!'\u000ea\u0001Y!91h\nb\u0001\n\u0013a\u0014aB7f[\n,'o]\u000b\u0002{A!ah\u0011\u0017F\u001b\u0005y$B\u0001!B\u0003\u001diW\u000f^1cY\u0016T!A\u0011\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002E\u007f\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u0005G\u0013\t9%A\u0001\bNK6\u0014WM]'fi\u0006$\u0017\r^1\t\r%;\u0003\u0015!\u0003>\u0003!iW-\u001c2feN\u0004\u0003bB&(\u0001\u0004%I\u0001T\u0001\u0006gR\fG/Z\u000b\u0002?!9aj\na\u0001\n\u0013y\u0015!C:uCR,w\fJ3r)\t\u00016\u000b\u0005\u0002\u000e#&\u0011!K\u0004\u0002\u0005+:LG\u000fC\u0004U\u001b\u0006\u0005\t\u0019A\u0010\u0002\u0007a$\u0013\u0007\u0003\u0004WO\u0001\u0006KaH\u0001\u0007gR\fG/\u001a\u0011\t\u000fa;\u0003\u0019!C\u00013\u0006aq-\u001a8fe\u0006$\u0018n\u001c8JIV\t!\f\u0005\u0002\u000e7&\u0011AL\u0004\u0002\u0004\u0013:$\bb\u00020(\u0001\u0004%\taX\u0001\u0011O\u0016tWM]1uS>t\u0017\nZ0%KF$\"\u0001\u00151\t\u000fQk\u0016\u0011!a\u00015\"1!m\nQ!\ni\u000bQbZ3oKJ\fG/[8o\u0013\u0012\u0004\u0003b\u00023(\u0001\u0004%\taK\u0001\tY\u0016\fG-\u001a:JI\"9am\na\u0001\n\u00039\u0017\u0001\u00047fC\u0012,'/\u00133`I\u0015\fHC\u0001)i\u0011\u001d!V-!AA\u00021BaA[\u0014!B\u0013a\u0013!\u00037fC\u0012,'/\u00133!\u0011\u001daw\u00051A\u0005\u0002-\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0005\b]\u001e\u0002\r\u0011\"\u0001p\u00031\u0001(o\u001c;pG>dw\fJ3r)\t\u0001\u0006\u000fC\u0004U[\u0006\u0005\t\u0019\u0001\u0017\t\rI<\u0003\u0015)\u0003-\u0003%\u0001(o\u001c;pG>d\u0007\u0005C\u0003uO\u0011\u0005Q/\u0001\u0002jgR\u0011a/\u001f\t\u0003\u001b]L!\u0001\u001f\b\u0003\u000f\t{w\u000e\\3b]\")!p\u001da\u0001?\u0005QqM]8vaN#\u0018\r^3\t\u000bq<C\u0011A?\u0002\u00079|G\u000f\u0006\u0002w}\")!p\u001fa\u0001?!9\u0011\u0011A\u0014\u0005\u0002\u0005\r\u0011a\u00015bgR\u0019a/!\u0002\t\r\u0005\u001dq\u00101\u0001-\u0003!iW-\u001c2fe&#\u0007bBA\u0006O\u0011\u0005\u0011QB\u0001\u0004O\u0016$HcA#\u0002\u0010!9\u0011qAA\u0005\u0001\u0004a\u0003bBA\nO\u0011\u0005\u0011QC\u0001\u0004C\u0012$G#\u0002)\u0002\u0018\u0005e\u0001bBA\u0004\u0003#\u0001\r\u0001\f\u0005\b\u00037\t\t\u00021\u0001F\u0003\u0019iW-\u001c2fe\"9\u0011qD\u0014\u0005\u0002\u0005\u0005\u0012A\u0002:f[>4X\rF\u0002Q\u0003GAq!a\u0002\u0002\u001e\u0001\u0007A\u0006\u0003\u0004\u0002(\u001d\"\t\u0001T\u0001\rGV\u0014(/\u001a8u'R\fG/\u001a\u0005\b\u0003W9C\u0011AA\u0017\u0003\u001dI7/R7qif,\u0012A\u001e\u0005\b\u0003c9C\u0011AA\u001a\u0003Uqw\u000e^-fiJ+'n\\5oK\u0012lU-\u001c2feN,\"!!\u000e\u0011\u000b\u0005]\u0012QH#\u000f\u00075\tI$C\u0002\u0002<9\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#\u0001\u0002'jgRT1!a\u000f\u000f\u0011\u001d\t)e\nC\u0001\u0003\u000f\n!\"\u00197m\u001b\u0016l'-\u001a:t+\t\tI\u0005E\u0003\u0002L\u00055C&D\u0001B\u0013\t!\u0013\tC\u0004\u0002R\u001d\"\t!a\r\u0002#\u0005dG.T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002V\u001d\"\t!W\u0001\u0011e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRDq!!\u0017(\t\u0003\tY&\u0001\fhK:,'/\u0019;f\u001b\u0016l'-\u001a:JIN+hMZ5y+\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&\u0019a&!\u0019\t\u000f\u00055t\u0005\"\u0001\u0002.\u0005a1-\u00198SK\n\fG.\u00198dK\"9\u0011\u0011O\u0014\u0005\u0002\u0005M\u0014\u0001\u0004;sC:\u001c\u0018\u000e^5p]R{Gc\u0001)\u0002v!1!0a\u001cA\u0002}Aa!!\u001f(\t\u0003Y\u0013AD:fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\b\u0003{:C\u0011BA@\u0003I\u0019\u0017M\u001c3jI\u0006$X\r\u0015:pi>\u001cw\u000e\\:\u0016\u0005\u0005\u0005\u0005#BAB\u0003\u0013cSBAAC\u0015\r\t9)Q\u0001\nS6lW\u000f^1cY\u0016L1\u0001JAC\u0011\u001d\tii\nC\u0001\u0003\u001f\u000b\u0011c];qa>\u0014Ho\u001d)s_R|7m\u001c7t)\r1\u0018\u0011\u0013\u0005\t\u0003'\u000bY\t1\u0001\u0002\u0016\u0006yQ.Z7cKJ\u0004&o\u001c;pG>d7\u000fE\u0002\u001aG1Bq!!'(\t\u0003\tY*\u0001\nj]&$h*\u001a=u\u000f\u0016tWM]1uS>tG#\u0001)\t\u000f\u0005}u\u0005\"\u0001\u0002\"\u0006)2-\u001e:sK:$X*Z7cKJlU\r^1eCR\fWCAAR!\u0015IB\u0004LAS!\u0015i\u0011qUAV\u0013\r\tIK\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001b\u00055\u0016bAAX\u001d\t!!)\u001f;f\u0011\u001d\t\u0019l\nC\u0001\u0003k\u000bqa];n[\u0006\u0014\u00180\u0006\u0002\u00028B\u0019\u0001\"!/\n\u0007\u0005m&A\u0001\u0007He>,\boU;n[\u0006\u0014\u0018\u0010C\u0004\u0002@\u001e\"\t!!1\u0002\u0011=4XM\u001d<jK^,\"!a1\u0011\u0007!\t)-C\u0002\u0002H\n\u0011Qb\u0012:pkB|e/\u001a:wS\u0016<\bbBAfO\u0011%\u0011QZ\u0001\u0016CN\u001cXM\u001d;WC2LG\r\u0016:b]NLG/[8o)\r\u0001\u0016q\u001a\u0005\b\u0003#\fI\r1\u0001 \u0003-!\u0018M]4fiN#\u0018\r^3\t\u000f\u0005Uw\u0005\"\u0011\u0002X\u0006AAo\\*ue&tw\rF\u0001-Q\r9\u00131\u001c\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011\u001d\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u0015\u0018q\u001c\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class GroupMetadata {
    private final String groupId;
    private final String protocolType;
    private final HashMap<String, MemberMetadata> members;
    private GroupState state;
    private int generationId;
    private String leaderId;
    private String protocol;

    public String groupId() {
        return this.groupId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(String x$1) {
        this.leaderId = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null;
    }

    public boolean has(String memberId) {
        return this.members().contains(memberId);
    }

    public MemberMetadata get(String memberId) {
        return this.members().apply(memberId);
    }

    public void add(String memberId, MemberMetadata member) {
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.leaderId() == null) {
            this.leaderId_$eq(memberId);
        }
        this.members().put(memberId, member);
    }

    public void remove(String memberId) {
        this.members().remove(memberId);
        String string2 = memberId;
        String string3 = this.leaderId();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.leaderId_$eq(this.members().isEmpty() ? null : (String)this.members().keys().head());
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public boolean isEmpty() {
        return this.members().isEmpty();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MemberMetadata x$1) {
                return x$1.awaitingJoinCallback() == null;
            }
        })).toList();
    }

    public org.graylog.shaded.kafka09.scala.collection.Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeout() {
        return BoxesRunTime.unboxToInt(this.members().values().foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int timeout, MemberMetadata member) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(timeout), member.sessionTimeoutMs());
            }
        }));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRebalance() {
        GroupState groupState = this.state();
        Stable$ stable$ = Stable$.MODULE$;
        if (groupState == null) {
            if (stable$ == null) return true;
        } else if (groupState.equals(stable$)) return true;
        GroupState groupState2 = this.state();
        AwaitingSync$ awaitingSync$ = AwaitingSync$.MODULE$;
        if (groupState2 != null) {
            if (!groupState2.equals(awaitingSync$)) return false;
            return true;
        }
        if (awaitingSync$ == null) return true;
        return false;
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        Set<String> candidates = this.candidateProtocols();
        List<Tuple2<String, Object>> votes = ((TraversableLike)this.allMemberMetadata().map(new Serializable(this, candidates){
            public static final long serialVersionUID = 0L;
            private final Set candidates$1;

            public final String apply(MemberMetadata x$2) {
                return x$2.vote(this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        }, List$.MODULE$.canBuildFrom())).groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return Predef$.MODULE$.identity(x);
            }
        }).mapValues(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(List<String> x$3) {
                return x$3.size();
            }
        }).toList();
        return votes.maxBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$4) {
                return x$4._2$mcI$sp();
            }
        }, Ordering$Int$.MODULE$)._1();
    }

    private Set<String> candidateProtocols() {
        return ((LinearSeqOptimized)this.allMemberMetadata().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<String> apply(MemberMetadata x$5) {
                return x$5.protocols();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<String> apply(Set<String> commonProtocols, Set<String> protocols2) {
                return (Set)commonProtocols.$amp(protocols2);
            }
        });
    }

    public boolean supportsProtocols(Set<String> memberProtocols) {
        return this.isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list2 = this.notYetRejoinedMembers();
        GenTraversable genTraversable = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list2 != null ? !((Object)list2).equals(genTraversable) : genTraversable != null));
        this.generationId_$eq(this.generationId() + 1);
        this.protocol_$eq(this.selectProtocol());
        this.transitionTo(AwaitingSync$.MODULE$);
    }

    public Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1<String, MemberMetadata>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Tuple2<String, byte[]> apply(Tuple2<String, MemberMetadata> x0$1) {
                Tuple2<String, MemberMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    String memberId = tuple2._1();
                    MemberMetadata memberMetadata = tuple2._2();
                    Tuple2<String, byte[]> tuple22 = new Tuple2<String, byte[]>(memberId, memberMetadata.metadata(this.$outer.protocol()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summary(this.$outer.protocol());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType(), this.protocol(), members);
        } else {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summaryNoMetadata();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType(), GroupCoordinator$.MODULE$.NoProtocol(), members);
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), this.protocolType());
    }

    private void assertValidTransition(GroupState targetState) {
        if (((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$GroupMetadata$$validPreviousStates().apply(targetState)).contains(this.state())) {
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$GroupMetadata$$validPreviousStates().apply(targetState)).mkString(","), targetState, this.state()})));
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("[%s,%s,%s,%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), this.protocolType(), this.currentState().toString(), this.members()}));
    }

    public GroupMetadata(String groupId, String protocolType) {
        this.groupId = groupId;
        this.protocolType = protocolType;
        this.members = new HashMap();
        this.state = Stable$.MODULE$;
        this.generationId = 0;
        this.leaderId = null;
        this.protocol = null;
    }
}

