/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.net.jpountz.lz4;

import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4Exception;
import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4JNI;
import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4SafeDecompressor;
import org.graylog.shaded.kafka09.net.jpountz.util.Utils;

final class LZ4JNISafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JNISafeDecompressor();

    LZ4JNISafeDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int result2 = LZ4JNI.LZ4_decompress_safe(src, srcOff, srcLen, dest, destOff, maxDestLen);
        if (result2 < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result2) + " of input buffer");
        }
        return result2;
    }
}

